/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.engine;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import xyz.brassgoggledcoders.transport.api.engine.EngineModule;
import xyz.brassgoggledcoders.transport.api.engine.PoweredState;
import xyz.brassgoggledcoders.transport.api.entity.IHoldable;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;

public abstract class EngineModuleInstance
extends ModuleInstance<EngineModule>
implements IHoldable {
    private PoweredState poweredState = PoweredState.RUNNING;

    protected EngineModuleInstance(EngineModule engineModule, IModularEntity componentCarrier) {
        super(engineModule, componentCarrier);
    }

    public abstract boolean isRunning();

    public abstract double getMaximumSpeed();

    @Nonnull
    public PoweredState getPoweredState() {
        return this.poweredState;
    }

    public void setPoweredState(@Nonnull PoweredState poweredState) {
        this.poweredState = poweredState;
    }

    protected void handleParticles(IParticleData particleData, int runningAmount) {
        if (this.getPoweredState() == PoweredState.IDLE) {
            runningAmount *= 2;
        }
        if (this.isRunning() && this.getModularEntity().getTheWorld().field_73012_v.nextInt(runningAmount) == 0) {
            this.getModularEntity().getTheWorld().func_195594_a(particleData, this.getModularEntity().getSelf().func_226277_ct_(), this.getModularEntity().getSelf().func_226278_cu_() + 0.8, this.getModularEntity().getSelf().func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onHeld() {
        this.setPoweredState(PoweredState.IDLE);
    }

    @Override
    public void onRelease() {
        this.setPoweredState(PoweredState.RUNNING);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        compoundNBT.func_74778_a("poweredState", this.poweredState.name());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.poweredState = PoweredState.byName(nbt.func_74779_i("poweredState"));
    }
}

