/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.network.server;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curiousshulkerboxes.CuriousShulkerBoxes;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;

public class SPacketSyncAnimation {
    private final int entityId;
    private final String identifier;
    private final int index;
    private final boolean isClosing;

    public SPacketSyncAnimation(int entityId, String identifier, int index, boolean isClosing) {
        this.entityId = entityId;
        this.identifier = identifier;
        this.index = index;
        this.isClosing = isClosing;
    }

    public static void encode(SPacketSyncAnimation msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.identifier);
        buf.writeInt(msg.index);
        buf.writeBoolean(msg.isClosing);
    }

    public static SPacketSyncAnimation decode(PacketBuffer buf) {
        return new SPacketSyncAnimation(buf.readInt(), buf.func_150789_c(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncAnimation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosAPI.getCuriosHandler((LivingEntity)livingEntity).ifPresent(handler -> {
                ItemStack stack;
                Block block;
                CurioStackHandler stackHandler = handler.getStackHandler(msg.identifier);
                if (stackHandler != null && msg.index < stackHandler.getSlots() && CuriousShulkerBoxes.isShulkerBox(block = ShulkerBoxBlock.func_149634_a((Item)(stack = stackHandler.getStackInSlot(msg.index)).func_77973_b()))) {
                    CuriosAPI.getCurio((ItemStack)stack).ifPresent(curio -> {
                        if (curio instanceof CurioShulkerBox) {
                            if (msg.isClosing) {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.CLOSING);
                            } else {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.OPENING);
                            }
                        }
                    });
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

