/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.tile.ModuleTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyModuleTile
extends ModuleTile<EnergyModuleTile> {
    @Save
    private NBTEnergyHandler energyHandler = new NBTEnergyHandler((BasicTile)this, 10000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyHandler);

    public EnergyModuleTile() {
        super(CommonProxy.BLOCK_CAPABILITY_ENERGY_MODULE);
        this.addGuiAddonFactory(() -> new EnergyBarScreenAddon(10, 20, (IEnergyStorage)this.energyHandler));
    }

    @Nonnull
    public LazyOptional getCapability(@Nonnull Capability cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (!this.isInput()) {
            for (Direction facing : Direction.values()) {
                BlockPos checking = this.field_174879_c.func_177972_a(facing);
                TileEntity checkingTile = this.field_145850_b.func_175625_s(checking);
                if (checkingTile == null) continue;
                checkingTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(storage -> {
                    int energy = storage.receiveEnergy(Math.min(this.energyHandler.getEnergyStored(), 1000), false);
                    if (energy > 0) {
                        this.energyHandler.extractEnergy(energy, false);
                        return;
                    }
                });
            }
        }
    }

    @Nonnull
    public EnergyModuleTile getSelf() {
        return this;
    }
}

