/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.data;

import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.data.PortalLinkData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class PortalDataManager
extends WorldSavedData {
    public static final String NAME = "Portality";
    private List<PortalInformation> informationList = new ArrayList<PortalInformation>();

    public PortalDataManager(String name) {
        super(name);
    }

    public PortalDataManager() {
        this(NAME);
    }

    public static void addInformation(World world, PortalInformation information) {
        if (world instanceof ServerWorld) {
            PortalDataManager dataManager = PortalDataManager.getData(world);
            dataManager.getInformationList().add(information);
            dataManager.func_76185_a();
        }
    }

    public static void removeInformation(World world, BlockPos blockPos) {
        if (world instanceof ServerWorld) {
            PortalDataManager dataManager = PortalDataManager.getData(world);
            dataManager.getInformationList().removeIf(information1 -> information1.getLocation().equals((Object)blockPos));
            dataManager.func_76185_a();
        }
    }

    @Nullable
    public static PortalInformation getInfoFromID(World world, UUID uuid) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getId().equals(uuid)) continue;
            return information;
        }
        return null;
    }

    @Nullable
    public static PortalInformation getInfoFromPos(World world, BlockPos pos) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            return information;
        }
        return null;
    }

    @Nullable
    public static PortalInformation getInfoFromLink(World world, PortalLinkData data) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (information.getDimension() != data.getDimension() || !information.getLocation().equals((Object)data.getPos())) continue;
            return information;
        }
        return null;
    }

    public static void setPortalPrivacy(World world, BlockPos pos, boolean privacy) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            information.setPrivate(privacy);
            dataManager.func_76185_a();
        }
    }

    public static void setPortalName(World world, BlockPos pos, String name) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            information.setName(name);
            dataManager.func_76185_a();
        }
    }

    public static void setPortalInterdimensional(World world, BlockPos pos, boolean interdimensional) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            information.setInterdimensional(interdimensional);
            dataManager.func_76185_a();
        }
    }

    public static void setPortalDisplay(World world, BlockPos pos, ItemStack stack) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            information.setDisplay(stack);
            dataManager.func_76185_a();
        }
    }

    @Nullable
    public static PortalDataManager getData(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = ((ServerWorld)world).func_73046_m().func_71218_a(DimensionType.field_223227_a_);
            PortalDataManager data = (PortalDataManager)serverWorld.func_217481_x().func_215752_a(PortalDataManager::new, NAME);
            return data;
        }
        return null;
    }

    public static void setActiveStatus(World world, BlockPos pos, boolean active) {
        PortalDataManager dataManager = PortalDataManager.getData(world);
        for (PortalInformation information : dataManager.getInformationList()) {
            if (!information.getLocation().equals((Object)pos)) continue;
            information.setActive(active);
            dataManager.func_76185_a();
        }
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.informationList.clear();
        CompoundNBT root = nbt.func_74775_l(NAME);
        for (String key : root.func_150296_c()) {
            CompoundNBT info = root.func_74775_l(key);
            this.informationList.add(PortalInformation.readFromNBT(info));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        for (PortalInformation information : this.informationList) {
            tag.func_218657_a(information.getId().toString(), (INBT)information.writetoNBT());
        }
        compound.func_218657_a(NAME, (INBT)tag);
        return compound;
    }

    public List<PortalInformation> getInformationList() {
        return this.informationList;
    }
}

