/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.block;

import com.buuz135.portality.Portality;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.tile.ControllerTile;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class ControllerBlock
extends RotatableBlock<ControllerTile> {
    public ControllerBlock() {
        super("controller", Block.Properties.func_200945_a((Material)Material.field_151576_e), ControllerTile.class);
        this.setItemGroup(Portality.TAB);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        PortalInformation information = new PortalInformation(UUID.randomUUID(), placer.func_110124_au(), false, false, worldIn.func_201675_m().func_186058_p().func_186068_a(), pos, "Dim: " + DimensionType.func_212678_a((DimensionType)worldIn.func_201675_m().func_186058_p()).func_110623_a() + " X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z: " + pos.func_177952_p(), new ItemStack(CommonProxy.BLOCK_FRAME), false);
        PortalDataManager.addInformation(worldIn, information);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
        PortalDataManager.removeInformation(worldIn.func_201672_e(), pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
        PortalDataManager.removeInformation(worldIn, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING_HORIZONTAL, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult ray) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ControllerTile) {
            ControllerTile controller = (ControllerTile)tile;
            if (!worldIn.func_201670_d()) {
                if (!controller.isFormed()) {
                    playerIn.func_146105_b(new TranslationTextComponent("portality.controller.error.size", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    return ActionResultType.SUCCESS;
                }
                if (controller.isPrivate() && !controller.getOwner().equals(playerIn.func_110124_au())) {
                    playerIn.func_146105_b(new TranslationTextComponent("portality.controller.error.privacy", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    return ActionResultType.SUCCESS;
                }
                if (playerIn.func_213453_ef() && controller.getOwner().equals(playerIn.func_110124_au()) && !playerIn.func_184586_b(hand).func_190926_b() && !playerIn.func_184586_b(hand).func_77969_a(controller.getDisplay())) {
                    playerIn.func_146105_b(new TranslationTextComponent("portility.controller.info.icon_changed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    controller.setDisplayNameEnabled(playerIn.func_184586_b(hand));
                    return ActionResultType.SUCCESS;
                }
            } else if (controller.isFormed()) {
                if (controller.isPrivate() && !controller.getOwner().equals(playerIn.func_110124_au())) {
                    return ActionResultType.SUCCESS;
                }
                Minecraft.func_71410_x().func_213165_a(() -> ControllerTile.OpenGui.open(0, (ControllerTile)tile));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, playerIn, hand, ray);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof ControllerTile) {
            ((ControllerTile)entity).breakController();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public IFactory<ControllerTile> getTileEntityFactory() {
        return ControllerTile::new;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ControllerTile();
    }
}

