/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.IVariant;

public interface IBlock<E extends IVariant>
extends IForgeBlock {
    default public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new BlockItemBase(this.getBlock(), properties, group);
    }

    public E getVariant();

    default public boolean hasTileEntity(BlockState state) {
        return this.createTileEntity(state, null) != null;
    }

    default public boolean hideGroup() {
        return false;
    }

    default public int stackSize() {
        return 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean hasEffect(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderByItem(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer rtb, int light, int ov) {
    }

    default public ItemStack toStack() {
        return new ItemStack((IItemProvider)this.getBlock());
    }

    default public ItemStack toStack(int count) {
        return new ItemStack((IItemProvider)this.getBlock(), count);
    }
}

