/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiBookEntry
extends GuiBook
implements IComponentRenderContext {
    final BookEntry entry;
    BookPage leftPage;
    BookPage rightPage;
    final Map<Button, Runnable> customButtons = new HashMap<Button, Runnable>();

    public GuiBookEntry(Book book, BookEntry entry) {
        this(book, entry, 0);
    }

    public GuiBookEntry(Book book, BookEntry entry, int spread) {
        super(book, (ITextComponent)new StringTextComponent(entry.getName()));
        this.entry = entry;
        this.spread = spread;
    }

    @Override
    public void init() {
        super.init();
        this.maxSpreads = (int)Math.ceil((float)this.entry.getPages().size() / 2.0f);
        this.setupPages();
    }

    @Override
    public void onFirstOpened() {
        int index;
        super.onFirstOpened();
        boolean dirty = false;
        String key = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        if (!data.viewedEntries.contains(key)) {
            data.viewedEntries.add(key);
            dirty = true;
            this.entry.markReadStateDirty();
        }
        if ((index = data.history.indexOf(key)) != 0) {
            if (index > 0) {
                data.history.remove(key);
            }
            data.history.add(0, key);
            while (data.history.size() > 13) {
                data.history.remove(13);
            }
            dirty = true;
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        this.drawPage(this.leftPage, mouseX, mouseY, partialTicks);
        this.drawPage(this.rightPage, mouseX, mouseY, partialTicks);
        if (this.rightPage == null) {
            GuiBookEntry.drawPageFiller(this.leftPage.book);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.clickPage(this.leftPage, mouseX, mouseY, mouseButton) || this.clickPage(this.rightPage, mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    void drawPage(BookPage page, int mouseX, int mouseY, float pticks) {
        if (page == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)page.left, (float)page.top, (float)0.0f);
        page.render(mouseX - page.left, mouseY - page.top, pticks);
        RenderSystem.popMatrix();
    }

    boolean clickPage(BookPage page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)page.left, mouseY - (double)page.top, mouseButton);
        }
        return false;
    }

    @Override
    void onPageChanged() {
        this.setupPages();
        this.needsBookmarkUpdate = true;
    }

    void setupPages() {
        this.customButtons.clear();
        if (this.leftPage != null) {
            this.leftPage.onHidden(this);
        }
        if (this.rightPage != null) {
            this.rightPage.onHidden(this);
        }
        List<BookPage> pages = this.entry.getPages();
        int leftNum = this.spread * 2;
        int rightNum = this.spread * 2 + 1;
        this.leftPage = leftNum < pages.size() ? pages.get(leftNum) : null;
        BookPage bookPage = this.rightPage = rightNum < pages.size() ? pages.get(rightNum) : null;
        if (this.leftPage != null) {
            this.leftPage.onDisplayed(this, 15, 18);
        }
        if (this.rightPage != null) {
            this.rightPage.onDisplayed(this, 141, 18);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookEntry && ((GuiBookEntry)obj).entry == this.entry && ((GuiBookEntry)obj).spread == this.spread;
    }

    @Override
    public boolean canBeOpened() {
        return !this.entry.isLocked() && !this.equals(Minecraft.func_71410_x().field_71462_r);
    }

    @Override
    protected boolean shouldAddAddBookmarkButton() {
        return !this.isBookmarkedAlready();
    }

    boolean isBookmarkedAlready() {
        if (this.entry == null || this.entry.getId() == null) {
            return false;
        }
        String entryKey = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : data.bookmarks) {
            if (!bookmark.entry.equals(entryKey) || bookmark.page != this.spread) continue;
            return true;
        }
        return false;
    }

    @Override
    public void bookmarkThis() {
        String entryKey = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        data.bookmarks.add(new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.spread));
        PersistentData.save();
        this.needsBookmarkUpdate = true;
    }

    public static void displayOrBookmark(GuiBook currGui, BookEntry entry) {
        Book book = currGui.book;
        GuiBookEntry gui = new GuiBookEntry(currGui.book, entry);
        if (Screen.hasShiftDown()) {
            PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(book);
            if (gui.isBookmarkedAlready()) {
                String key = entry.getId().toString();
                data.bookmarks.removeIf(bm -> bm.entry.equals(key) && bm.page == 0);
                PersistentData.save();
                currGui.needsBookmarkUpdate = true;
                return;
            }
            if (data.bookmarks.size() < 10) {
                gui.bookmarkThis();
                currGui.needsBookmarkUpdate = true;
                return;
            }
        }
        book.contents.openLexiconGui(gui, true);
    }

    @Override
    public Screen getGui() {
        return this;
    }

    @Override
    public FontRenderer getFont() {
        return this.book.getFont();
    }

    @Override
    public void renderItemStack(int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        this.minecraft.func_175599_af().func_180450_b(stack, x, y);
        this.minecraft.func_175599_af().func_175030_a(this.font, stack, x, y);
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
        RenderHelper.func_74518_a();
    }

    @Override
    public void renderIngredient(int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        ItemStack[] stacks = ingr.func_193365_a();
        if (stacks.length > 0) {
            this.renderItemStack(x, y, mouseX, mouseY, stacks[this.ticksInBook / 20 % stacks.length]);
        }
    }

    @Override
    public void setHoverTooltip(List<String> tooltip) {
        this.setTooltip(tooltip.stream().map(StringTextComponent::new).collect(Collectors.toList()));
    }

    @Override
    public void setHoverTooltipComponents(@Nonnull List<ITextComponent> tooltip) {
        this.setTooltip(tooltip);
    }

    @Override
    public boolean isAreaHovered(int mouseX, int mouseY, int x, int y, int w, int h) {
        return this.isMouseInRelativeRange(mouseX, mouseY, x, y, w, h);
    }

    @Override
    public void registerButton(Button button, int pageNum, Runnable onClick) {
        button.x = button.x + (this.bookLeft + (pageNum % 2 == 0 ? 15 : 141));
        button.y += this.bookTop;
        this.customButtons.put(button, onClick);
        this.addButton(button);
    }

    @Override
    public ResourceLocation getBookTexture() {
        return this.book.bookTexture;
    }

    @Override
    public ResourceLocation getCraftingTexture() {
        return this.book.craftingTexture;
    }

    @Override
    public int getTextColor() {
        return this.book.textColor;
    }

    @Override
    public int getHeaderColor() {
        return this.book.headerColor;
    }

    @Override
    public int getTicksInBook() {
        return this.ticksInBook;
    }
}

