/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.comforts.common.block.ComfortsBaseBlock;
import top.theillusivec4.comforts.common.block.RopeAndNailBlock;
import top.theillusivec4.comforts.common.tileentity.HammockTileEntity;

public class HammockBlock
extends ComfortsBaseBlock {
    private static final VoxelShape HAMMOCK_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(ComfortsBaseBlock.BedType.HAMMOCK, color, Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185854_g).func_200943_b(0.1f));
        this.color = color;
        this.setRegistryName("comforts", "hammock_" + color.func_176762_d());
    }

    public static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.func_176734_d();
    }

    public static boolean skipToNight(ServerWorld world) {
        boolean[] skipToNight = new boolean[]{false};
        List players = world.func_217369_A();
        for (PlayerEntity player2 : players) {
            player2.func_213374_dv().ifPresent(bedPos -> {
                if (player2.func_71026_bH() && world.func_180495_p(bedPos).func_177230_c() instanceof HammockBlock) {
                    if (world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                        long i = world.func_72820_D() + 24000L;
                        long worldTime = world.func_72820_D() % 24000L;
                        if (worldTime > 500L && worldTime < 11500L) {
                            world.func_72877_b(i - i % 24000L - 12001L);
                        }
                    }
                    skipToNight[0] = true;
                }
            });
            if (!skipToNight[0]) continue;
            break;
        }
        if (skipToNight[0]) {
            ObfuscationReflectionHelper.setPrivateValue(ServerWorld.class, (Object)world, (Object)false, (String)"field_73068_P");
            players.stream().filter(LivingEntity::func_70608_bn).forEach(player -> player.func_225652_a_(false, false));
            if (world.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                world.field_73011_w.resetRainAndThunder();
            }
            return true;
        }
        return false;
    }

    public static void dropRopeSupport(BlockPos pos, Direction direction, boolean isHead, World worldIn) {
        BlockPos ropePos = isHead ? pos.func_177972_a(direction) : pos.func_177972_a(direction.func_176734_d());
        BlockState ropeState = worldIn.func_180495_p(ropePos);
        if (ropeState.func_177230_c() instanceof RopeAndNailBlock) {
            worldIn.func_175656_a(ropePos, (BlockState)ropeState.func_206870_a((IProperty)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void finishHammockDrops(BlockState state, BlockPos pos, BlockState otherState, BlockPos otherPos, Direction direction, World worldIn, @Nullable PlayerEntity player) {
        boolean isHead;
        BedPart bedpart = (BedPart)otherState.func_177229_b((IProperty)BedBlock.field_176472_a);
        boolean bl = isHead = bedpart == BedPart.HEAD;
        if (((Boolean)otherState.func_177229_b((IProperty)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(otherPos, Blocks.field_150355_j.func_176223_P(), 35);
        } else {
            worldIn.func_180501_a(otherPos, Blocks.field_150350_a.func_176223_P(), 35);
        }
        worldIn.func_217378_a(player, 2001, otherPos, Block.func_196246_j((BlockState)otherState));
        HammockBlock.dropRopeSupport(otherPos, direction, isHead, worldIn);
        if (!worldIn.field_72995_K) {
            ItemStack itemstack = ItemStack.field_190927_a;
            if (player != null) {
                if (player.func_184812_l_()) {
                    return;
                }
                itemstack = player.func_184614_ca();
            }
            HammockBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
            HammockBlock.func_220054_a((BlockState)otherState, (World)worldIn, (BlockPos)otherPos, null, (Entity)player, (ItemStack)itemstack);
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = HammockBlock.func_226862_h_((BlockState)state).func_176734_d();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return HAMMOCK_SHAPE;
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        BedPart bedpart = (BedPart)state.func_177229_b((IProperty)field_176472_a);
        boolean isHead = bedpart == BedPart.HEAD;
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        BlockPos otherPos = pos.func_177972_a(HammockBlock.getDirectionToOther(bedpart, direction));
        BlockState otherState = worldIn.func_180495_p(otherPos);
        if (otherState.func_177230_c() == this && otherState.func_177229_b((IProperty)field_176472_a) != bedpart) {
            HammockBlock.finishHammockDrops(state, pos, otherState, otherPos, direction, worldIn, player);
            HammockBlock.dropRopeSupport(pos, direction, isHead, worldIn);
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        worldIn.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)direction)).func_206870_a((IProperty)ComfortsBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a)) : null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new HammockTileEntity(this.color);
    }
}

