/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.teleporter.blocks.SimpleDialerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class SimpleDialerBlock
extends LogicSlabBlock {
    public SimpleDialerBlock() {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"transmitter", SimpleDialerBlock::getTransmitterInfo), TooltipBuilder.parameter((String)"receiver", SimpleDialerBlock::getReceiverInfo), TooltipBuilder.parameter((String)"once", SimpleDialerBlock::hasOnce, stack -> SimpleDialerBlock.hasOnce(stack) ? "Once mode enabled" : "")}).tileEntitySupplier(SimpleDialerTileEntity::new));
    }

    private static boolean hasOnce(ItemStack stack) {
        return (Boolean)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74767_n, (String)"once", (Object)false);
    }

    private static String getTransmitterInfo(ItemStack stack) {
        if (NBTTools.hasInfoNBT((ItemStack)stack, (String)"transX")) {
            int transX = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"transX", (Object)0);
            int transY = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"transY", (Object)0);
            int transZ = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"transZ", (Object)0);
            String dim = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"transZ", (Object)DimensionType.field_223227_a_.getRegistryName().toString());
            return transX + "," + transY + "," + transZ + " (dim " + dim + ")";
        }
        return "<unset>";
    }

    private static String getReceiverInfo(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> Integer.toString(info.func_74762_e(s)), (String)"receiver", (Object)"<unset>");
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        SimpleDialerTileEntity simpleDialerTileEntity;
        if (!world.field_72995_K && (simpleDialerTileEntity = (SimpleDialerTileEntity)world.func_175625_s(pos)) != null) {
            boolean onceMode = !simpleDialerTileEntity.isOnceMode();
            simpleDialerTileEntity.setOnceMode(onceMode);
            if (onceMode) {
                Logging.message((PlayerEntity)player, (String)"Enabled 'dial once' mode");
            } else {
                Logging.message((PlayerEntity)player, (String)"Disabled 'dial once' mode");
            }
        }
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, p_220069_6_);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SimpleDialerTileEntity) {
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)te;
            simpleDialerTileEntity.update();
        }
    }
}

