/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataFactory;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnScreenData {
    private GlobalCoordinate pos;
    private Map<Integer, IModuleData> screenData;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos.getCoordinate());
        buf.writeInt(this.pos.getDimension().func_186068_a());
        buf.writeInt(this.screenData.size());
        for (Map.Entry<Integer, IModuleData> me : this.screenData.entrySet()) {
            buf.writeInt(me.getKey().intValue());
            IModuleData c = me.getValue();
            buf.writeInt(RFToolsUtility.screenModuleRegistry.getShortId(c.getId()));
            c.writeToBuf(buf);
        }
    }

    public GlobalCoordinate getPos() {
        return this.pos;
    }

    public Map<Integer, IModuleData> getScreenData() {
        return this.screenData;
    }

    public PacketReturnScreenData() {
    }

    public PacketReturnScreenData(PacketBuffer buf) {
        this.pos = new GlobalCoordinate(buf.func_179259_c(), DimensionType.func_186069_a((int)buf.readInt()));
        int size = buf.readInt();
        this.screenData = new HashMap<Integer, IModuleData>(size);
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            int shortId = buf.readInt();
            String id = RFToolsUtility.screenModuleRegistry.getNormalId(shortId);
            IModuleDataFactory<?> dataFactory = RFToolsUtility.screenModuleRegistry.getModuleDataFactory(id);
            IModuleData data = dataFactory.createData(buf);
            this.screenData.put(key, data);
        }
    }

    public PacketReturnScreenData(GlobalCoordinate pos, Map<Integer, IModuleData> screenData) {
        this.pos = pos;
        this.screenData = screenData;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ScreenTileEntity.screenData.put(this.getPos(), this.getScreenData()));
        ctx.setPacketHandled(true);
    }
}

