/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.screen.MachineInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnRfInRange {
    private Map<BlockPos, MachineInfo> levels;
    public static Map<BlockPos, MachineInfo> clientLevels;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.levels.size());
        for (Map.Entry<BlockPos, MachineInfo> entry : this.levels.entrySet()) {
            buf.func_179255_a(entry.getKey());
            MachineInfo info = entry.getValue();
            buf.writeLong(info.getEnergy());
            buf.writeLong(info.getMaxEnergy());
            if (info.getEnergyPerTick() != null) {
                buf.writeBoolean(true);
                buf.writeLong(info.getEnergyPerTick().longValue());
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public Map<BlockPos, MachineInfo> getLevels() {
        return this.levels;
    }

    public PacketReturnRfInRange() {
    }

    public PacketReturnRfInRange(PacketBuffer buf) {
        int size = buf.readInt();
        this.levels = new HashMap<BlockPos, MachineInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.func_179259_c();
            long e = buf.readLong();
            long m = buf.readLong();
            Long usage = null;
            if (buf.readBoolean()) {
                usage = buf.readLong();
            }
            this.levels.put(pos, new MachineInfo(e, m, usage));
        }
    }

    public PacketReturnRfInRange(Map<BlockPos, MachineInfo> levels) {
        this.levels = levels;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            clientLevels = this.levels;
        });
        ctx.setPacketHandled(true);
    }
}

