/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public class ScreenLevelHelper
implements ILevelRenderHelper {
    private boolean hidebar = false;
    private boolean hidetext = false;
    private boolean showdiff = false;
    private boolean showpct = false;
    private FormatStyle formatStyle = FormatStyle.MODE_FULL;
    private int poscolor = 0xFFFFFF;
    private int negcolor = 0xFFFFFF;
    private int gradient1 = -65536;
    private int gradient2 = -13421824;
    private String label = "";
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y, @Nullable IModuleDataContents data, @Nonnull ModuleRenderInfo renderInfo) {
        if (data == null) {
            return;
        }
        long maxContents = data.getMaxContents();
        if (maxContents > 0L && !this.hidebar) {
            int width;
            long contents = data.getContents();
            long value = contents * (long)(width = 80 - x + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)x, (int)y, (int)((int)((long)x + value)), (int)(y + 8), (int)this.gradient1, (int)this.gradient2, (int)renderInfo.getLightmapValue());
        }
        if (!this.hidetext) {
            String diffTxt = null;
            int col = this.poscolor;
            if (this.showdiff) {
                long diff = data.getLastPerTick();
                if (diff < 0L) {
                    col = this.negcolor;
                    diffTxt = diff + " " + this.label + "/t";
                } else {
                    diffTxt = "+" + diff + " " + this.label + "/t";
                }
            } else if (maxContents > 0L) {
                long contents = data.getContents();
                if (this.showpct) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    diffTxt = value + "%";
                } else {
                    diffTxt = this.format(String.valueOf(contents), this.formatStyle) + this.label;
                }
            }
            if (diffTxt != null) {
                ScreenTextHelper.renderScaled((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, diffTxt, (int)x, (int)y, (int)col, (boolean)renderInfo.truetype, (int)renderInfo.getLightmapValue());
            }
        }
    }

    public ILevelRenderHelper label(String label) {
        this.label = label;
        return this;
    }

    public ILevelRenderHelper settings(boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff) {
        this.hidebar = hidebar;
        this.hidetext = hidetext;
        this.showpct = showpct;
        this.showdiff = showdiff;
        return this;
    }

    public ILevelRenderHelper color(int poscolor, int negcolor) {
        this.poscolor = poscolor;
        this.negcolor = negcolor;
        return this;
    }

    public ILevelRenderHelper gradient(int gradient1, int gradient2) {
        this.gradient1 = gradient1;
        this.gradient2 = gradient2;
        return this;
    }

    public ILevelRenderHelper format(FormatStyle formatStyle) {
        this.formatStyle = formatStyle;
        return this;
    }

    private String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

