/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import mcjty.rftoolsutility.modules.logic.network.PacketRemoveChannel;
import mcjty.rftoolsutility.modules.logic.network.PacketSetRedstone;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class GuiRedstoneInformation
extends GenericGuiContainer<GenericTileEntity, RedstoneInformationContainer> {
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsutility", "textures/gui/redstone_information.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    public static final int WIDTH = 200;
    public static final int HEIGHT = 190;
    private WidgetList list;

    public GuiRedstoneInformation(RedstoneInformationContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsUtility.instance, null, (Container)container, inventory, ManualHelper.create((String)"rftoolsutility:logic/redstone_information"));
        this.field_146999_f = 200;
        this.field_147000_g = 190;
    }

    public void init() {
        super.init();
        this.list = ((WidgetList)Widgets.list((int)5, (int)5, (int)180, (int)180).name("list")).propagateEventsToChildren(true);
        Slider slider = Widgets.slider((int)185, (int)5, (int)10, (int)180).scrollableName("list");
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.list, slider});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.fillList();
    }

    private void removeChannel(int channel) {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketRemoveChannel(channel));
    }

    private void setRedstone(int channel, String newChoice) {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketSetRedstone(channel, "1".equals(newChoice) ? 15 : 0));
    }

    private boolean isDirty() {
        Map<Integer, Pair<String, Integer>> data = ((RedstoneInformationContainer)this.field_147002_h).getChannelData();
        if (data == null) {
            return true;
        }
        if (data.size() != this.list.getChildCount()) {
            return true;
        }
        for (int i = 0; i < this.list.getChildCount(); ++i) {
            Panel panel = (Panel)this.list.getChild(i);
            Integer channel = (Integer)panel.getUserObject();
            if (data.containsKey(channel)) continue;
            return true;
        }
        return false;
    }

    private void updateList() {
        if (this.isDirty()) {
            this.fillList();
        }
        Map<Integer, Pair<String, Integer>> data = ((RedstoneInformationContainer)this.field_147002_h).getChannelData();
        for (int i = 0; i < this.list.getChildCount(); ++i) {
            Panel panel = (Panel)this.list.getChild(i);
            Integer channel = (Integer)panel.getUserObject();
            Pair<String, Integer> pair = data.get(channel);
            if (pair == null) continue;
            Label name = (Label)panel.findChild("name");
            ImageChoiceLabel choice = (ImageChoiceLabel)panel.findChild("choice");
            Label value = (Label)panel.findChild("value");
            if (((String)pair.getLeft()).isEmpty()) {
                name.text("" + channel);
            } else {
                name.text(channel + " (" + (String)pair.getLeft() + ")");
            }
            choice.setCurrentChoice((Integer)pair.getRight() > 0 ? "1" : "0");
            value.text(Integer.toString((Integer)pair.getRight()));
        }
    }

    protected void drawWindow() {
        this.updateList();
        super.drawWindow();
    }

    private void fillList() {
        this.list.removeChildren();
        Map<Integer, Pair<String, Integer>> data = ((RedstoneInformationContainer)this.field_147002_h).getChannelData();
        if (data == null) {
            return;
        }
        Set<Integer> channels = data.keySet();
        List sortedChannels = channels.stream().sorted().collect(Collectors.toList());
        for (Integer channel : sortedChannels) {
            Panel panel = (Panel)((Panel)Widgets.horizontal().desiredHeight(18)).userObject((Object)channel);
            ImageChoiceLabel choice = ((ImageChoiceLabel)((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().name("choice")).desiredWidth(16)).desiredHeight(16)).choice("0", "Redstone off", guiElements, 16, 0).choice("1", "Redstone on", guiElements, 32, 0).event(newChoice -> this.setRedstone(channel, newChoice));
            Label valueLabel = (Label)((Label)((Label)Widgets.label((String)"0").name("value")).desiredWidth(30)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            panel.children(new Widget[]{((Label)((Label)Widgets.label((String)("" + channel)).name("name")).desiredWidth(60)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT), choice, valueLabel, Widgets.button((String)"Remove").event(() -> this.removeChannel(channel))});
            this.list.children(new Widget[]{panel});
        }
    }
}

