/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockSetup;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class AnalogTileEntity
extends LogicTileEntity {
    public static final String CMD_UPDATE = "analog.update";
    public static final Key<Double> PARAM_MUL_EQ = new Key("mul_eq", Type.DOUBLE);
    public static final Key<Double> PARAM_MUL_LESS = new Key("mul_less", Type.DOUBLE);
    public static final Key<Double> PARAM_MUL_GT = new Key("mul_gt", Type.DOUBLE);
    public static final Key<Integer> PARAM_ADD_EQ = new Key("add_eq", Type.INTEGER);
    public static final Key<Integer> PARAM_ADD_LESS = new Key("add_less", Type.INTEGER);
    public static final Key<Integer> PARAM_ADD_GT = new Key("add_gt", Type.INTEGER);
    private float mulEqual = 1.0f;
    private float mulLess = 1.0f;
    private float mulGreater = 1.0f;
    private int addEqual = 0;
    private int addLess = 0;
    private int addGreater = 0;
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Analog").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockSetup.CONTAINER_ANALOG.get(), windowId.intValue(), (ContainerFactory)EmptyContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)));
    private static Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public AnalogTileEntity() {
        super((TileEntityType)LogicBlockSetup.TYPE_ANALOG.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(AnalogTileEntity::new));
    }

    public float getMulEqual() {
        return this.mulEqual;
    }

    public void setMulEqual(float mulEqual) {
        this.mulEqual = mulEqual;
        this.markDirtyQuick();
    }

    public float getMulLess() {
        return this.mulLess;
    }

    public void setMulLess(float mulLess) {
        this.mulLess = mulLess;
        this.markDirtyQuick();
    }

    public float getMulGreater() {
        return this.mulGreater;
    }

    public void setMulGreater(float mulGreater) {
        this.mulGreater = mulGreater;
        this.markDirtyQuick();
    }

    public int getAddEqual() {
        return this.addEqual;
    }

    public void setAddEqual(int addEqual) {
        this.addEqual = addEqual;
    }

    public int getAddLess() {
        return this.addLess;
    }

    public void setAddLess(int addLess) {
        this.addLess = addLess;
    }

    public int getAddGreater() {
        return this.addGreater;
    }

    public void setAddGreater(int addGreater) {
        this.addGreater = addGreater;
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.mulEqual = info.func_74760_g("mulE");
        this.mulLess = info.func_74760_g("mulL");
        this.mulGreater = info.func_74760_g("mulG");
        this.addEqual = info.func_74762_e("addE");
        this.addLess = info.func_74762_e("addL");
        this.addGreater = info.func_74762_e("addG");
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74776_a("mulE", this.mulEqual);
        info.func_74776_a("mulL", this.mulLess);
        info.func_74776_a("mulG", this.mulGreater);
        info.func_74768_a("addE", this.addEqual);
        info.func_74768_a("addL", this.addLess);
        info.func_74768_a("addG", this.addGreater);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_UPDATE.equals(command)) {
            this.mulEqual = ((Double)params.get(PARAM_MUL_EQ)).floatValue();
            this.mulLess = ((Double)params.get(PARAM_MUL_LESS)).floatValue();
            this.mulGreater = ((Double)params.get(PARAM_MUL_GT)).floatValue();
            this.addEqual = (Integer)params.get(PARAM_ADD_EQ);
            this.addLess = (Integer)params.get(PARAM_ADD_LESS);
            this.addGreater = (Integer)params.get(PARAM_ADD_GT);
            this.markDirtyClient();
            this.checkRedstone(this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = this.getFacing(state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                int inputStrength = this.getInputStrength(world, pos, inputSide);
                int inputLeft = this.getInputStrength(world, pos, leftSide);
                int inputRight = this.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * this.getMulEqual() + (float)this.getAddEqual()) : (inputLeft < inputRight ? (int)((float)inputStrength * this.getMulLess() + (float)this.getAddLess()) : (int)((float)inputStrength * this.getMulGreater() + (float)this.getAddGreater()));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = this.getPowerLevel();
                this.setPowerInput(outputStrength);
                if (oldPower != outputStrength) {
                    world.func_195593_d(pos, this.func_195044_w().func_177230_c());
                }
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (side == this.getFacing(state).getInputSide()) {
            return this.getPowerLevel();
        }
        return 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

