/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderMiningLaser {
    private static final ResourceLocation laserBeam = new ResourceLocation("mininggadgets:textures/misc/laser.png");
    private static final ResourceLocation laserBeam2 = new ResourceLocation("mininggadgets:textures/misc/laser2.png");
    private static final ResourceLocation laserBeamGlow = new ResourceLocation("mininggadgets:textures/misc/laser_glow.png");

    public static void renderLaser(RenderWorldLastEvent event, PlayerEntity player, float ticks) {
        ItemStack stack = MiningGadget.getGadget(player);
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        int range = MiningProperties.getBeamRange(stack);
        Vec3d playerPos = player.func_174824_e(ticks);
        RayTraceResult trace = player.func_213324_a((double)range, 0.0f, false);
        float speedModifier = RenderMiningLaser.getSpeedModifier(stack);
        RenderMiningLaser.drawLasers(event, playerPos, trace, 0.0, 0.0, 0.0, (float)MiningProperties.getColor(stack, "colorRed") / 255.0f, (float)MiningProperties.getColor(stack, "colorGreen") / 255.0f, (float)MiningProperties.getColor(stack, "colorBlue") / 255.0f, 0.02f, player, ticks, speedModifier);
    }

    private static float getSpeedModifier(ItemStack stack) {
        if (UpgradeTools.containsUpgrade(stack, Upgrade.EFFICIENCY_1)) {
            double efficiency = (float)UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier() / 5.0f;
            double speedModifier = MathHelper.func_219803_d((double)efficiency, (double)0.02, (double)0.05);
            return (float)(-speedModifier);
        }
        return -0.02f;
    }

    private static void drawLasers(RenderWorldLastEvent event, Vec3d from, RayTraceResult trace, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, PlayerEntity player, float ticks, float speedModifier) {
        Hand activeHand;
        if (player.func_184614_ca().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.OFF_HAND;
        } else {
            return;
        }
        ItemStack stack = player.func_184586_b(activeHand);
        double distance = from.func_178788_d(trace.func_216347_e()).func_72433_c();
        long gameTime = player.field_70170_p.func_82737_E();
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderMiningLaser.calculateLaserFlickerModifier(gameTime);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        Vec3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227861_a_(view.func_82615_a(), view.func_82617_b(), view.func_82616_c());
        if (trace.func_216346_c() == RayTraceResult.Type.MISS) {
            matrix.func_227861_a_(-from.field_72450_a, -from.field_72448_b, -from.field_72449_c);
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        RenderSystem.enableColorMaterial();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableTexture();
        RenderSystem.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)(-player.field_70177_z), (float)(-player.field_70126_B)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)player.field_70125_A, (float)player.field_70127_C), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)0.7f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeamGlow);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, additiveThickness, activeHand, distance, wr, 0.5, 1.0, ticks);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam2);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, thickness, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        RenderSystem.color4f((float)((float)MiningProperties.getColor(stack, "colorRedInner") / 255.0f), (float)((float)MiningProperties.getColor(stack, "colorGreenInner") / 255.0f), (float)((float)MiningProperties.getColor(stack, "colorBlueInner") / 255.0f), (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, thickness / 2.0f, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.popMatrix();
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * MathHelper.func_76126_a((float)((float)gameTime * 0.99f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.3f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(double xOffset, double yOffset, double zOffset, float thickness, Hand hand, double distance, BufferBuilder wr, double v1, double v2, float ticks) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float startXOffset = -0.25f;
        float startYOffset = -0.115f;
        float startZOffset = 0.65f + (1.0f - player.func_175156_o());
        float f = MathHelper.func_219799_g((float)ticks, (float)player.field_70127_C, (float)player.field_70125_A) - MathHelper.func_219799_g((float)ticks, (float)player.field_71164_i, (float)player.field_71155_g);
        float f1 = MathHelper.func_219799_g((float)ticks, (float)player.field_70126_B, (float)player.field_70177_z) - MathHelper.func_219799_g((float)ticks, (float)player.field_71163_h, (float)player.field_71154_f);
        startXOffset += f1 / 1000.0f;
        startYOffset += f / 1000.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_186715_A != HandSide.RIGHT) {
            hand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        }
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (hand == Hand.MAIN_HAND) {
            wr.func_225582_a_((double)startXOffset, (double)(-thickness + startYOffset), (double)startZOffset).func_225583_a_(1.0f, (float)v1).func_181675_d();
            wr.func_225582_a_(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_225583_a_(1.0f, (float)v2).func_181675_d();
            wr.func_225582_a_(xOffset, (double)thickness + yOffset, distance + zOffset).func_225583_a_(0.0f, (float)v2).func_181675_d();
            wr.func_225582_a_((double)startXOffset, (double)(thickness + startYOffset), (double)startZOffset).func_225583_a_(0.0f, (float)v1).func_181675_d();
        } else {
            startYOffset = -0.12f;
            wr.func_225582_a_((double)(-startXOffset), (double)(thickness + startYOffset), (double)startZOffset).func_225583_a_(0.0f, (float)v1).func_181675_d();
            wr.func_225582_a_(xOffset, (double)thickness + yOffset, distance + zOffset).func_225583_a_(0.0f, (float)v2).func_181675_d();
            wr.func_225582_a_(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_225583_a_(1.0f, (float)v2).func_181675_d();
            wr.func_225582_a_((double)(-startXOffset), (double)(-thickness + startYOffset), (double)startZOffset).func_225583_a_(1.0f, (float)v1).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }
}

