/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderBlockTER
extends TileEntityRenderer<RenderBlockTileEntity> {
    public RenderBlockTER(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private void renderModelBrightnessColorQuads(MatrixStack.Entry matrixEntry, IVertexBuilder builder, float red, float green, float blue, float alpha, List<BakedQuad> listQuads, int combinedLightsIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.func_178212_b()) {
                f = red * 1.0f;
                f1 = green * 1.0f;
                f2 = blue * 1.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            builder.addVertexData(matrixEntry, bakedquad, f, f1, f2, alpha, combinedLightsIn, combinedOverlayIn);
        }
    }

    public void render(RenderBlockTileEntity tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        BlockState renderState;
        float nowScale;
        int durability = tile.getDurability();
        int originalDurability = tile.getOriginalDurability();
        int prevDurability = tile.getPriorDurability();
        float prevScale = (float)prevDurability / (float)originalDurability;
        float scale = MathHelper.func_219799_g((float)partialTicks, (float)prevScale, (float)(nowScale = (float)durability / (float)originalDurability));
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        if (scale <= 0.0f) {
            scale = 0.0f;
        }
        if ((renderState = tile.getRenderBlock()) == null) {
            return;
        }
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        MiningProperties.BreakTypes breakType = tile.getBreakType();
        IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(renderState);
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_228054_a_(renderState, (ILightReader)tile.func_145831_w(), tile.func_174877_v(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        matrixStackIn.func_227860_a_();
        if (breakType == MiningProperties.BreakTypes.SHRINK) {
            matrixStackIn.func_227861_a_((double)((1.0f - scale) / 2.0f), (double)((1.0f - scale) / 2.0f), (double)((1.0f - scale) / 2.0f));
            matrixStackIn.func_227862_a_(scale, scale, scale);
            for (Direction direction : Direction.values()) {
                this.renderModelBrightnessColorQuads(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(RenderType.func_228643_e_()), f, f1, f2, 1.0f, ibakedmodel.getQuads(renderState, direction, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v())), (IModelData)EmptyModelData.INSTANCE), combinedLightsIn, combinedOverlayIn);
            }
        } else if (breakType == MiningProperties.BreakTypes.FADE) {
            scale = MathHelper.func_219799_g((float)scale, (float)0.1f, (float)1.0f);
            for (Direction direction : Direction.values()) {
                if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177972_a(direction)).func_177230_c() instanceof RenderBlock) continue;
                this.renderModelBrightnessColorQuads(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(MyRenderType.RenderBlock), f, f1, f2, scale, ibakedmodel.getQuads(renderState, direction, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v())), (IModelData)EmptyModelData.INSTANCE), combinedLightsIn, combinedOverlayIn);
            }
        }
        matrixStackIn.func_227865_b_();
    }
}

