/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.blocks.RelatedBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;

public class Pole
extends RelatedBlock
implements IWaterLoggable {
    public static boolean easyBuilding = true;
    public static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    protected static final Predicate<BlockState> IS_TORCH = state -> state.func_177230_c() instanceof TorchBlock;
    protected static final BiPredicate<IWorldReader, BlockPos> IS_EMPTY_PLACE = (w, p) -> GameWorld.isAirBlock((IWorldReader)w, (BlockPos)p) || GameWorld.isWaterBlock((IWorldReader)w, (BlockPos)p);
    private final float acceleration;
    private final EnumMap<Velocity, Float> maxVelocityMap = new EnumMap(Velocity.class);

    public Pole(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props.nameSuffix("pole"));
        for (Velocity vel : Velocity.values()) {
            float defaultValue = vel.bounds.approxUp(props.speedFactor).floatValue();
            defaultValue = GameMath.roundTo((float)defaultValue, (int)-2);
            String category = Names.dotted().join(new String[]{this.getUnitCategory(), "maxVelocity"});
            String comment = "Defines the maximum " + vel.func_176610_l() + " speed, " + vel.getDirection() + " the pole.";
            float value = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)vel.func_176610_l(), (float)defaultValue, (FloatBounds)vel.bounds, (String)comment);
            this.maxVelocityMap.put(vel, Float.valueOf(value));
        }
        this.acceleration = UnitConfig.getFloat((UnitConfig)config, (String)this.getUnitCategory(), (String)"acceleration", (float)0.04f, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.1f)), (String)"Defines how fast sliding velocity changes.");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((IWorld)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return IWaterLoggable.getStateForPlacement((BlockItemUseContext)context, (BlockState)this.func_176223_P());
    }

    @VisibleForTesting
    public void setTestValues() {
    }

    public static boolean isOneBlockNear(Entity entity) {
        World world = entity.func_130014_f_();
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_());
        for (Direction facing : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
            BlockPos checkPos = pos.func_177972_a(facing);
            if (!Pole.isPole((IWorldReader)world, checkPos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockPos findReachableFor(Entity entity) {
        World world = entity.func_130014_f_();
        Vec3d look = entity.func_70040_Z();
        look = new Vec3d(look.field_72450_a, 0.0, look.field_72449_c);
        AxisAlignedBB bb = entity.func_174813_aQ();
        bb = bb.func_191194_a(look);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int y = MathHelper.func_76128_c((double)bb.field_72338_b);
        while ((double)y <= bb.field_72337_e) {
            int x = MathHelper.func_76128_c((double)bb.field_72340_a);
            while ((double)x <= bb.field_72336_d) {
                int z = MathHelper.func_76128_c((double)bb.field_72339_c);
                while ((double)z <= bb.field_72334_f) {
                    pos.func_181079_c(x, y, z);
                    if (Pole.isPole((IWorldReader)world, (BlockPos)pos)) {
                        return pos.func_185334_h();
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return null;
    }

    @Nullable
    public static Holder getHolderFor(Entity entity) {
        Entity riding = entity.func_184187_bx();
        return riding instanceof Holder ? (Holder)riding : null;
    }

    public static void releaseFrom(Entity entity) {
        Holder holder = Pole.getHolderFor(entity);
        if (holder != null) {
            holder.func_70106_y();
        }
    }

    public static boolean canBeHeldBy(Entity entity) {
        return entity.func_70089_S() && !entity.func_184218_aH() && !entity.func_213453_ef() && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_175149_v());
    }

    public static Vec3d getCenterWithY(BlockPos pos, double y) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
    }

    @Nullable
    public static Pole getAt(IWorldReader world, BlockPos pos) {
        return AdPoles.getPoles().findBy(world, pos);
    }

    public static boolean isPole(IWorldReader world, BlockPos pos) {
        return Pole.getAt(world, pos) != null;
    }

    public static boolean hasLengthIn(World world, BlockPos pos, Direction direction, int length) {
        int count;
        for (count = 0; count < length && Pole.isPole((IWorldReader)world, pos.func_177967_a(direction, count)); ++count) {
        }
        return count >= length;
    }

    public static boolean isRidable(World world, BlockPos pos) {
        Pole pole = Pole.getAt((IWorldReader)world, pos);
        if (pole == null || !pole.isEnabled()) {
            return false;
        }
        boolean maxObstacles = true;
        int count = 0;
        for (BlockPos check : GameWorld.Positions.getAroundHoriz((BlockPos)pos, (boolean)false, (BlockPos[])new BlockPos[0])) {
            if (Pole.isObstacle(world, check)) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return count <= 1;
    }

    public static boolean isObstacle(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos)) {
            return false;
        }
        if (state.func_200015_d((IBlockReader)world, pos)) {
            return true;
        }
        if (state.func_224755_d((IBlockReader)world, pos, Direction.DOWN)) {
            return true;
        }
        VoxelShape shape = state.func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB aabb = shape.func_197752_a();
        if (aabb == null) {
            return false;
        }
        double length = 0.5;
        return !(aabb.field_72336_d - aabb.field_72340_a < 0.5) || !(aabb.field_72334_f - aabb.field_72339_c < 0.5);
    }

    public static boolean isObstacleAbove(Entity entity, BlockPos pos) {
        double margin = 0.4f;
        double y = entity.func_226278_cu_() + (double)entity.func_213302_cg() + margin;
        BlockPos top = new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
        return Pole.isObstacle(entity.func_130014_f_(), top);
    }

    public static boolean isLongEnoughFor(Entity entity, BlockPos pos) {
        World world = entity.func_130014_f_();
        int length = MathHelper.func_76123_f((float)entity.func_213302_cg());
        return Pole.hasLengthIn(world, pos, Direction.UP, length);
    }

    public float getMaxVelocity(World world, BlockPos pos, Velocity velocity) {
        float waterReduction = IWaterLoggable.isWaterlogged((BlockState)world.func_180495_p(pos)) ? 4.0f : 1.0f;
        return this.maxVelocityMap.get((Object)velocity).floatValue() / waterReduction;
    }

    public Direction getSlideDirection(World world, BlockPos pos) {
        return Direction.DOWN;
    }

    public boolean isSamePole(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        if (Pole.isPole(world, down) || Pole.func_220055_a((IWorldReader)world, (BlockPos)down, (Direction)Direction.UP)) {
            return true;
        }
        BlockPos up = pos.func_177984_a();
        return Pole.isPole(world, up) || Pole.func_220055_a((IWorldReader)world, (BlockPos)up, (Direction)Direction.DOWN);
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public static BlockPos getTop(IWorldReader world, BlockPos startPos) {
        if (!Pole.isPole(world, startPos)) {
            return startPos;
        }
        BlockPos upper = startPos;
        while (Pole.isPole(world, upper = upper.func_177984_a())) {
        }
        return upper.func_177977_b();
    }

    public static boolean buildUp(World world, BlockPos startPos, BlockState addBlock) {
        if (!Pole.isPole((IWorldReader)world, startPos)) {
            return false;
        }
        BlockPos top = Pole.getTop((IWorldReader)world, startPos).func_177984_a();
        Optional<BlockState> torch = Optional.of(world.func_180495_p(top)).filter(IS_TORCH);
        if (torch.isPresent()) {
            if (!IS_EMPTY_PLACE.test((IWorldReader)world, top.func_177984_a())) {
                return false;
            }
            world.func_217377_a(top, false);
        }
        if (!IS_EMPTY_PLACE.test((IWorldReader)world, top)) {
            return false;
        }
        IntBounds bounds = IntBounds.from((Integer)startPos.func_177956_o(), (Integer)top.func_177956_o());
        BlockPos.Mutable pos = new BlockPos.Mutable(startPos);
        BlockState replacement = addBlock;
        Iterator iterator = bounds.iterator();
        while (iterator.hasNext()) {
            int y = (Integer)iterator.next();
            pos.func_185336_p(y);
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (state == (replacement = Pole.getStateForReplacement(replacement, (IWorldReader)world, (BlockPos)pos, state)) || !world.func_175656_a((BlockPos)pos, replacement)) continue;
            IWaterLoggable.updateFluidPostPlacement((IWorld)world, (BlockPos)pos, (BlockState)replacement);
            replacement = state;
        }
        if (torch.isPresent()) {
            world.func_175656_a(top.func_177984_a(), torch.get());
        }
        return true;
    }

    public static boolean breakDown(IWorld world, BlockPos brokenPos) {
        if (!IS_EMPTY_PLACE.test((IWorldReader)world, brokenPos)) {
            return false;
        }
        BlockPos startPos = brokenPos.func_177984_a();
        if (!Pole.isPole((IWorldReader)world, startPos)) {
            return false;
        }
        BlockPos top = Pole.getTop((IWorldReader)world, startPos);
        Optional<BlockState> torch = Optional.of(world.func_180495_p(top.func_177984_a())).filter(IS_TORCH);
        if (torch.isPresent()) {
            world.func_217377_a(top.func_177984_a(), false);
        }
        BlockPos.Mutable pos = new BlockPos.Mutable(top);
        BlockState replacement = world.func_204610_c((BlockPos)pos).func_206883_i();
        for (int y = top.func_177956_o(); y >= brokenPos.func_177956_o(); --y) {
            pos.func_185336_p(y);
            BlockState state = world.func_180495_p((BlockPos)pos);
            replacement = Pole.getStateForReplacement(replacement, (IWorldReader)world, (BlockPos)pos, state);
            if (state == replacement || !GameWorld.setBlockState((IWorldWriter)world, (BlockPos)pos, (BlockState)replacement)) continue;
            IWaterLoggable.updateFluidPostPlacement((IWorld)world, (BlockPos)pos, (BlockState)replacement);
            replacement = state;
        }
        if (torch.isPresent()) {
            GameWorld.setBlockState((IWorldWriter)world, (BlockPos)top, (BlockState)torch.get());
        }
        return true;
    }

    protected static BlockState getStateForReplacement(BlockState replacement, IWorldReader world, BlockPos pos, BlockState state) {
        if (replacement.func_196959_b((IProperty)WATERLOGGED)) {
            replacement = (BlockState)replacement.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(IWaterLoggable.isWaterlogged((BlockState)state)));
            replacement = IWaterLoggable.getStateForPlacementAt((IWorldReader)world, (BlockPos)pos, (BlockState)replacement);
        }
        return replacement;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Pole heldPole;
        if (!easyBuilding || hit.func_216354_b().func_176740_k().func_200128_b()) {
            return ActionResultType.PASS;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        ItemUseContext context = new ItemUseContext(player, hand, hit);
        Block heldBlock = Pole.func_149634_a((Item)heldStack.func_77973_b());
        BlockState heldState = heldBlock.func_196258_a(new BlockItemUseContext(context));
        Pole pole = heldPole = heldState != null ? AdPoles.getPoles().findBy(heldState) : null;
        if (heldPole == null) {
            return ActionResultType.PASS;
        }
        if (this.isServerSide((IWorldReader)world)) {
            if (Pole.buildUp(world, pos, heldState)) {
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            return this.canBuildUp(world, pos) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    protected boolean canBuildUp(World world, BlockPos startPos) {
        BlockPos top = Pole.getTop((IWorldReader)world, startPos).func_177984_a();
        if (IS_TORCH.test(world.func_180495_p(top))) {
            top = top.func_177984_a();
        }
        return IS_EMPTY_PLACE.test((IWorldReader)world, top);
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (this.isServerSide((IWorldReader)world)) {
            Pole.breakDown(world, pos);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedBlock.Properties<T> {
        public float speedFactor;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> withId(String relatedBlockId) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)props.id(relatedBlockId);
        }

        public T speedFactor(float speedFactor) {
            this.speedFactor = speedFactor;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Velocity implements IForgeEnum
    {
        CLIMBING(0.0f, 0.4f, "up"),
        SLIDING(0.0f, 0.8f, "down"),
        SPINNING(0.0f, 0.2f, "around");

        public final FloatBounds bounds;
        private final String direction;

        private Velocity(float min, float max, String direction) {
            this.bounds = FloatBounds.from((Float)Float.valueOf(min), (Float)Float.valueOf(max));
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }
    }
}

