/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.spawnitems;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemMobSpawner
extends Item {
    private final EntityType<?> type;

    public ItemMobSpawner(EntityType<?> type) {
        this(type, new Item.Properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    public ItemMobSpawner(EntityType<?> type, Item.Properties builder) {
        super(builder);
        this.type = type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            ItemStack heldItem = context.func_195996_i();
            BlockPos clickPos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(clickPos);
            BlockPos spawnPos = blockstate.func_196952_d((IBlockReader)world, clickPos).func_197766_b() ? clickPos : clickPos.func_177972_a(direction);
            EntityType<?> spawnType = this.getType(heldItem.func_77978_p());
            if (spawnType.func_220331_a(world, heldItem, context.func_195999_j(), spawnPos, SpawnReason.SPAWN_EGG, true, !Objects.equals(clickPos, spawnPos) && direction == Direction.UP) != null) {
                heldItem.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)heldItem);
        }
        RayTraceResult traceResult = ItemMobSpawner.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)heldItem);
        }
        BlockRayTraceResult blockTraceResult = (BlockRayTraceResult)traceResult;
        BlockPos blockpos = blockTraceResult.func_216350_a();
        if (!(world.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return new ActionResult(ActionResultType.PASS, (Object)heldItem);
        }
        if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, blockTraceResult.func_216354_b(), heldItem)) {
            EntityType<?> entitytype = this.getType(heldItem.func_77978_p());
            if (entitytype.func_220331_a(world, heldItem, player, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return new ActionResult(ActionResultType.PASS, (Object)heldItem);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
    }

    public EntityType<?> getType(@Nullable CompoundNBT itemTag) {
        CompoundNBT entityTag;
        if (itemTag != null && itemTag.func_150297_b("EntityTag", 10) && (entityTag = itemTag.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)entityTag.func_74779_i("id")).orElse(this.type);
        }
        return this.type;
    }
}

