/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.dust;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.darkutils.DarkUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeDustChange
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final Ingredient item;
    private final BlockIngredient input;
    private final BlockIngredient output;

    public RecipeDustChange(ResourceLocation id, Ingredient item, BlockIngredient input, BlockIngredient output) {
        this.id = id;
        this.item = item;
        this.input = input;
        this.output = output;
    }

    @Deprecated
    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return DarkUtils.content.recipeSerializerDustChange;
    }

    public IRecipeType<?> func_222127_g() {
        return DarkUtils.content.recipeTypeDustChange;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)DarkUtils.content.dustPurify);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public Block getOutput(Random rand) {
        return (Block)this.output.getValidBlocks().get(rand.nextInt(this.output.getValidBlocks().size()));
    }

    public boolean isValid(BlockState state, ItemStack dustItem) {
        return this.item.test(dustItem) && this.input.test(state.func_177230_c()) && !this.output.getValidBlocks().isEmpty();
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeDustChange> {
        private Serializer() {
        }

        public RecipeDustChange read(ResourceLocation recipeId, JsonObject json) {
            Ingredient item = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("item"));
            BlockIngredient input = BlockIngredient.deserialize((JsonElement)json.getAsJsonObject("input"));
            BlockIngredient output = BlockIngredient.deserialize((JsonElement)json.getAsJsonObject("output"));
            return new RecipeDustChange(recipeId, item, input, output);
        }

        public RecipeDustChange read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient item = Ingredient.func_199566_b((PacketBuffer)buffer);
            BlockIngredient input = BlockIngredient.deserialize((PacketBuffer)buffer);
            BlockIngredient output = BlockIngredient.deserialize((PacketBuffer)buffer);
            return new RecipeDustChange(recipeId, item, input, output);
        }

        public void write(PacketBuffer buffer, RecipeDustChange recipe) {
            recipe.item.func_199564_a(buffer);
            recipe.input.serialize(buffer);
            recipe.output.serialize(buffer);
        }
    }
}

