/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.u_team_core.api.registry.IUBlockRegistryType;
import info.u_team.useful_railroads.init.UsefulRailroadsItemGroups;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class CustomPoweredRailBlock
extends PoweredRailBlock
implements IUBlockRegistryType {
    protected final String name;
    protected final BlockItem blockItem;

    public CustomPoweredRailBlock(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e), true);
        this.name = name + "_rail";
        this.blockItem = this.createBlockItem(new Item.Properties().func_200916_a((ItemGroup)UsefulRailroadsItemGroups.GROUP));
    }

    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new BlockItem((Block)this, blockItemProperties);
    }

    public String getEntryName() {
        return this.name;
    }

    public BlockItem getBlockItem() {
        return this.blockItem;
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        this.moveAlongTrack(pos, state, cart);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state, AbstractMinecartEntity cart) {
        Entity passenger;
        boolean powered = false;
        boolean notPoweredMovement = false;
        AbstractRailBlock railBlock = (AbstractRailBlock)state.func_177230_c();
        RailShape shape = railBlock.getRailDirection(state, (IBlockReader)cart.field_70170_p, pos, cart);
        if (railBlock == this) {
            powered = (Boolean)state.func_177229_b((IProperty)PoweredRailBlock.field_176569_M);
            notPoweredMovement = !powered;
        }
        Entity entity = passenger = cart.func_184188_bt().isEmpty() ? null : (Entity)cart.func_184188_bt().get(0);
        if (passenger instanceof PlayerEntity) {
            Vec3d passengerMotion = passenger.func_213322_ci();
            double passengerDistanceSqr = CustomPoweredRailBlock.getPlaneSqrDistance(passengerMotion);
            double cartDistanceSqr = CustomPoweredRailBlock.getPlaneSqrDistance(cart.func_213322_ci());
            if (passengerDistanceSqr > 1.0E-4 && cartDistanceSqr < 0.01) {
                cart.func_213317_d(cart.func_213322_ci().func_72441_c(passengerMotion.field_72450_a * 0.1, 0.0, passengerMotion.field_72449_c * 0.1));
                notPoweredMovement = false;
            }
        }
        if (notPoweredMovement && cart.shouldDoRailFunctions()) {
            double cartDistance = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.func_213322_ci());
            if (cartDistance < 0.03) {
                cart.func_213317_d(Vec3d.field_186680_a);
            } else {
                cart.func_213317_d(cart.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        if (powered && cart.shouldDoRailFunctions()) {
            Vec3d cartMotion = cart.func_213322_ci();
            double cartDistance = CustomPoweredRailBlock.getPlaneSqrtDistance(cartMotion);
            if (cartDistance > 0.01) {
                cart.func_213317_d(cartMotion.func_72441_c(cartMotion.field_72450_a / cartDistance * 0.06, 0.0, cartMotion.field_72449_c / cartDistance * 0.06));
                this.controllSpeed(pos, state, cart);
            } else {
                double xCartMotion = cartMotion.field_72450_a;
                double zCartMotion = cartMotion.field_72449_c;
                if (shape == RailShape.EAST_WEST) {
                    if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177976_e())) {
                        xCartMotion = 0.02;
                    } else if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177974_f())) {
                        xCartMotion = -0.02;
                    }
                } else {
                    if (shape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177978_c())) {
                        zCartMotion = 0.02;
                    } else if (CustomPoweredRailBlock.isNormalCube(cart.field_70170_p, pos.func_177968_d())) {
                        zCartMotion = -0.02;
                    }
                }
                cart.func_213293_j(xCartMotion, cartMotion.field_72448_b, zCartMotion);
            }
        }
    }

    protected void controllSpeed(BlockPos pos, BlockState state, AbstractMinecartEntity cart) {
    }

    protected void speedUpCart(AbstractMinecartEntity cart, double speedMultiplier, double speedClamp) {
        Vec3d motion = cart.func_213322_ci();
        cart.func_213315_a(MoverType.SELF, new Vec3d(MathHelper.func_151237_a((double)(speedMultiplier * motion.field_72450_a), (double)(-speedClamp), (double)speedClamp), 0.0, MathHelper.func_151237_a((double)(speedMultiplier * motion.field_72449_c), (double)(-speedClamp), (double)speedClamp)));
    }

    private static boolean isNormalCube(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_215686_e((IBlockReader)world, pos);
    }

    private static double getPlaneSqrtDistance(Vec3d vec) {
        return Math.sqrt(CustomPoweredRailBlock.getPlaneSqrDistance(vec));
    }

    private static double getPlaneSqrDistance(Vec3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c;
    }
}

