/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.silentchaos512.lib.util.DimPos;

public class TeleporterSL
extends Teleporter {
    private final DimPos pos;

    public static TeleporterSL of(ServerWorld world, DimPos pos) {
        return new TeleporterSL(world, pos);
    }

    public TeleporterSL(ServerWorld world, DimPos pos) {
        super(world);
        this.pos = DimPos.of(pos.getPos(), pos.getDimension());
    }

    public boolean func_222268_a(Entity p_222268_1_, float p_222268_2_) {
        return true;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        entity.func_213317_d(Vec3d.field_186680_a);
        entity.field_70143_R = 0.0f;
        Vec3d position = this.pos.getPosCentered(0.1);
        if (entity instanceof ServerPlayerEntity && ((ServerPlayerEntity)entity).field_71135_a != null) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(position.field_72450_a, position.field_72448_b, position.field_72449_c, yaw, entity.field_70125_A);
        } else {
            entity.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, yaw, entity.field_70125_A);
        }
    }

    @Nullable
    public Entity teleport(Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return entity;
        }
        if (this.pos.getDimension() != entity.field_71093_bK.func_186068_a()) {
            return entity instanceof ServerPlayerEntity ? TeleporterSL.changeDimension((ServerPlayerEntity)entity, this.pos) : this.changeDimensionEntity(entity, this.pos);
        }
        this.placeEntity(entity.field_70170_p, entity, entity.field_70177_z);
        return entity;
    }

    @Nullable
    public Entity teleportWithMount(Entity entity) {
        Entity mount = entity.func_184187_bx();
        if (mount != null) {
            entity.func_184210_p();
            this.teleport(mount);
        }
        this.teleport(entity);
        return entity;
    }

    @Nullable
    public static ServerPlayerEntity changeDimension(ServerPlayerEntity player, DimPos pos) {
        DimensionType newDimension = pos.getDimensionType();
        if (newDimension == null || !ForgeHooks.onTravelToDimension((Entity)player, (DimensionType)newDimension)) {
            return null;
        }
        if (player.field_70170_p.field_72995_K || !player.func_70089_S()) {
            return null;
        }
        player.field_184851_cj = true;
        DimensionType dimensiontype = player.field_71093_bK;
        ServerWorld serverworld = player.field_71133_b.func_71218_a(dimensiontype);
        player.field_71093_bK = newDimension;
        ServerWorld serverworld1 = player.field_71133_b.func_71218_a(newDimension);
        WorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(newDimension, serverworld1.func_72905_C(), worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.field_71133_b.func_184103_al();
        playerlist.func_187243_f(player);
        serverworld.removeEntity((Entity)player, true);
        player.revive();
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d position = pos.getPosCentered(0.1);
        player.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        player.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        player.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(player);
        player.field_71135_a.func_147364_a(position.field_72450_a, position.field_72448_b, position.field_72449_c, f1, f);
        player.field_71134_c.func_73080_a(serverworld1);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, serverworld1);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        player.field_71144_ck = -1;
        player.field_71149_ch = -1.0f;
        player.field_71146_ci = -1;
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)dimensiontype, (DimensionType)newDimension);
        return player;
    }

    @Nullable
    public Entity changeDimensionEntity(Entity entityIn, DimPos pos) {
        DimensionType newDimension = pos.getDimensionType();
        if (newDimension == null || !ForgeHooks.onTravelToDimension((Entity)entityIn, (DimensionType)newDimension)) {
            return null;
        }
        if (entityIn.field_70170_p.field_72995_K || !entityIn.func_70089_S()) {
            return null;
        }
        this.field_85192_a.func_217381_Z().func_76320_a("changeDimension");
        MinecraftServer minecraftserver = entityIn.func_184102_h();
        if (minecraftserver == null) {
            return null;
        }
        DimensionType oldDimension = entityIn.field_71093_bK;
        ServerWorld serverworld = minecraftserver.func_71218_a(oldDimension);
        ServerWorld serverworld1 = minecraftserver.func_71218_a(newDimension);
        entityIn.field_71093_bK = newDimension;
        entityIn.func_213319_R();
        this.field_85192_a.func_217381_Z().func_76320_a("reposition");
        Vec3d vec3d = entityIn.func_213322_ci();
        float f = 0.0f;
        this.field_85192_a.func_217381_Z().func_219895_b("reloading");
        Entity entity = entityIn.func_200600_R().func_200721_a((World)serverworld1);
        if (entity != null) {
            entity.func_180432_n(entityIn);
            entity.func_174828_a(pos.getPos(), entity.field_70177_z + f, entity.field_70125_A);
            entity.func_213317_d(vec3d);
            serverworld1.func_217460_e(entity);
        }
        this.field_85192_a.func_217381_Z().func_76319_b();
        serverworld.func_82742_i();
        serverworld1.func_82742_i();
        this.field_85192_a.func_217381_Z().func_76319_b();
        return entity;
    }

    public static boolean isSafePosition(IBlockReader worldIn, Entity entityIn, BlockPos pos) {
        int i = 1;
        while ((double)i < Math.ceil(entityIn.func_213302_cg())) {
            BlockPos up = pos.func_177981_b(i);
            if (!worldIn.func_180495_p(up).isAir(worldIn, up)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

