/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.tile;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.silentchaos512.lib.tile.FurnaceFuelBurner;
import net.silentchaos512.lib.tile.IFuelBurner;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.utils.MathUtils;

@Deprecated
public abstract class TileEntityItemProcessor
extends TileSidedInventorySL
implements ITickableTileEntity {
    private static final int LONG_UPDATE_DELAY = 20;
    @SyncVariable(name="Progress")
    private int progress = 0;
    @SyncVariable(name="Burner")
    @Nullable
    private IFuelBurner burner;
    private NonNullList<ItemStack> inputs;
    private NonNullList<ItemStack> fuels;
    private NonNullList<ItemStack> outputs;
    private Collection<ItemStack> overflow = ImmutableList.of();
    private int timer = MathUtils.nextInt(20);

    public TileEntityItemProcessor(TileEntityType<?> tileEntityType, int inputCount, int fuelCount, int outputCount) {
        this(tileEntityType, inputCount, fuelCount, outputCount, new FurnaceFuelBurner(FurnaceFuelBurner.BurnCondition.STANDARD));
    }

    public TileEntityItemProcessor(TileEntityType<?> tileEntityType, int inputCount, int fuelCount, int outputCount, @Nullable IFuelBurner burner) {
        super(tileEntityType, inputCount + fuelCount + outputCount);
        if (inputCount < 1) {
            throw new IllegalArgumentException("Input slot count must be greater than zero");
        }
        if (outputCount < 1) {
            throw new IllegalArgumentException("Output slot count must be greater than zero");
        }
        this.inputs = NonNullList.func_191197_a((int)inputCount, (Object)ItemStack.field_190927_a);
        this.fuels = NonNullList.func_191197_a((int)fuelCount, (Object)ItemStack.field_190927_a);
        this.outputs = NonNullList.func_191197_a((int)outputCount, (Object)ItemStack.field_190927_a);
        this.burner = burner;
    }

    protected abstract int getWorkTime(Collection<ItemStack> var1);

    protected abstract boolean canWork(Collection<ItemStack> var1);

    protected abstract Collection<ItemStack> getWorkResult(Collection<ItemStack> var1);

    protected abstract void consumeIngredients(Collection<ItemStack> var1);

    protected abstract boolean isInputItem(ItemStack var1);

    protected abstract boolean isFuelItem(ItemStack var1);

    private boolean hasSpaceForOutputs() {
        return this.overflow.isEmpty();
    }

    private ItemStack getFuelStack() {
        int start = this.getInputSlotCount();
        return this.getStackFromSlotRange(start, start + this.getFuelSlotCount());
    }

    @Deprecated
    private ItemStack getStackFromSlotRange(int startInclusive, int endExclusive) {
        for (int i = startInclusive; i < endExclusive; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean doWork() {
        ItemStack fuel;
        boolean requiresClientSync = false;
        boolean processing = false;
        if (!this.inputs.isEmpty() && this.canWork((Collection<ItemStack>)this.inputs) && this.hasSpaceForOutputs() && (this.burner == null || this.burner.hasFuel())) {
            int workTime = this.getWorkTime((Collection<ItemStack>)this.inputs);
            if (this.progress < workTime) {
                ++this.progress;
                requiresClientSync = true;
                processing = true;
            }
            if (this.progress >= workTime) {
                Collection<ItemStack> result = this.getWorkResult((Collection<ItemStack>)this.inputs);
                int slotStart = this.getInputSlotCount() + this.getFuelSlotCount();
                result = InventoryUtils.mergeItems(this, slotStart, slotStart + this.getOutputSlotCount(), result);
                if (!result.isEmpty()) {
                    this.overflow = result;
                }
                this.progress = 0;
                requiresClientSync = true;
            }
        }
        if (this.burner != null && this.burner.tickFuel(processing) && !this.burner.hasFuel() && !(fuel = this.getFuelStack()).func_190926_b()) {
            this.burner.feedFuel(fuel);
            fuel.func_190918_g(1);
        }
        return requiresClientSync;
    }

    public void func_73660_a() {
        ++this.timer;
        if (!this.field_145850_b.field_72995_K) {
            boolean requiresClientSync = this.doWork();
            if (this.timer % 20 == 0 && !this.overflow.isEmpty()) {
                int oldCount = this.overflow.size();
                int start = this.getInputSlotCount() + this.getFuelSlotCount();
                this.overflow = InventoryUtils.mergeItems(this, start, start + this.getOutputSlotCount(), this.overflow);
                requiresClientSync |= oldCount != this.overflow.size();
            }
            if (requiresClientSync) {
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        }
    }

    private int getInputSlotCount() {
        return this.inputs.size();
    }

    private int getFuelSlotCount() {
        return this.fuels.size();
    }

    private int getOutputSlotCount() {
        return this.outputs.size();
    }

    public int func_70302_i_() {
        return this.getInputSlotCount() + this.getFuelSlotCount() + this.getOutputSlotCount();
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (index >= this.getInputSlotCount() + this.getFuelSlotCount()) {
            return ItemStackHelper.func_188382_a(this.outputs, (int)(index - (this.getInputSlotCount() + this.getFuelSlotCount())), (int)count);
        }
        if (index >= this.getInputSlotCount() && this.getFuelSlotCount() > 0) {
            return ItemStackHelper.func_188382_a(this.fuels, (int)(index - this.getInputSlotCount()), (int)count);
        }
        return ItemStackHelper.func_188382_a(this.inputs, (int)index, (int)count);
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (index >= this.getInputSlotCount() + this.getFuelSlotCount()) {
            return (ItemStack)this.outputs.get(index - (this.getInputSlotCount() + this.getFuelSlotCount()));
        }
        if (index >= this.getInputSlotCount() && this.getFuelSlotCount() > 0) {
            return (ItemStack)this.fuels.get(index - this.getInputSlotCount());
        }
        return (ItemStack)this.inputs.get(index);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= this.getInputSlotCount() + this.getFuelSlotCount()) {
            return false;
        }
        if (index >= this.getInputSlotCount() && this.getFuelSlotCount() > 0) {
            return this.isFuelItem(stack);
        }
        return this.isInputItem(stack);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (index >= this.getInputSlotCount() + this.getFuelSlotCount()) {
            return ItemStackHelper.func_188383_a(this.outputs, (int)(index - (this.getInputSlotCount() + this.getFuelSlotCount())));
        }
        if (index >= this.getInputSlotCount() && this.getFuelSlotCount() > 0) {
            return ItemStackHelper.func_188383_a(this.fuels, (int)(index - this.getInputSlotCount()));
        }
        return ItemStackHelper.func_188383_a(this.inputs, (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index >= this.func_70302_i_()) {
            return;
        }
        if (index >= this.getInputSlotCount() + this.getFuelSlotCount()) {
            this.outputs.set(index - (this.getInputSlotCount() + this.getFuelSlotCount()), (Object)stack);
        } else if (index >= this.getInputSlotCount() && this.getFuelSlotCount() > 0) {
            this.fuels.set(index - this.getInputSlotCount(), (Object)stack);
        } else {
            this.inputs.set(index, (Object)stack);
        }
    }
}

