/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.awt.Point;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class MultiblockPattern {
    public static final MultiblockPattern DEFAULT = new MultiblockPattern(new ItemStack((IItemProvider)Items.field_151045_i), new String[]{"OQO", "QGQ", "OQO"}, new Point(1, 1), (Map<Character, Slot>)new HashMap<Character, Slot>(){
        {
            this.put(Character.valueOf('O'), new Slot(Blocks.field_150343_Z));
            this.put(Character.valueOf('Q'), new Slot(Blocks.field_150371_ca));
            this.put(Character.valueOf('G'), new Slot(Blocks.field_150426_aN));
        }
    });
    private final ItemStack catalyst;
    private final String[] shape;
    private final Point origin;
    private final Map<Character, Slot> definition;

    public MultiblockPattern(ItemStack catalyst, String[] shape, Point origin, Map<Character, Slot> definition) {
        this.catalyst = catalyst;
        this.shape = shape;
        this.origin = origin;
        this.definition = definition;
        this.definition.put(Character.valueOf(' '), new Slot(Blocks.field_150350_a.func_176223_P()));
        char originChar = shape[origin.y].charAt(origin.x);
        if (originChar == ' ' || definition.get(Character.valueOf(originChar)).test(Blocks.field_150350_a.func_176223_P())) {
            throw new IllegalStateException("Origin point cannot be blank space.");
        }
        int lineLength = shape[0].length();
        for (String line : shape) {
            if (line.length() != lineLength) {
                throw new IllegalStateException("All lines in the shape must be the same size.");
            }
            for (char letter : line.toCharArray()) {
                if (definition.get(Character.valueOf(letter)) != null) continue;
                throw new IllegalStateException(letter + " is not defined.");
            }
        }
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public ActionResult<Set<BlockPos>> match(World world, BlockPos originBlock) {
        HashSet matched = Sets.newHashSet();
        for (int y = 0; y < this.shape.length; ++y) {
            String line = this.shape[y];
            for (int x = 0; x < line.length(); ++x) {
                BlockPos offset = originBlock.func_177982_a(x - this.origin.x, 0, y - this.origin.y);
                BlockState state = world.func_180495_p(offset);
                if (!this.definition.get(Character.valueOf(line.charAt(x))).test(state)) {
                    return new ActionResult(ActionResultType.FAIL, Collections.emptySet());
                }
                matched.add(offset);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)matched);
    }

    public boolean isOriginBlock(BlockState state) {
        Slot slot = this.definition.get(Character.valueOf(this.shape[this.origin.y].charAt(this.origin.x)));
        return slot.test(state);
    }

    public static class SerializerBlockState
    implements JsonDeserializer<Set<BlockState>> {
        public Set<BlockState> deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashSet states = Sets.newHashSet();
            for (JsonElement entry : element.getAsJsonArray()) {
                String state = entry.getAsJsonPrimitive().getAsString();
                if (state.contains("[")) {
                    String[] stateValues;
                    String[] split = state.split("\\[");
                    split[1] = split[1].substring(0, split[1].lastIndexOf("]"));
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
                    if (block == Blocks.field_150350_a) {
                        return Collections.singleton(block.func_176223_P());
                    }
                    StateContainer blockState = block.func_176194_O();
                    BlockState returnState = (BlockState)blockState.func_177621_b();
                    for (String value : stateValues = split[1].split(",")) {
                        String[] valueSplit = value.split("=");
                        IProperty property = blockState.func_185920_a(valueSplit[0]);
                        if (property == null) continue;
                        returnState = (BlockState)returnState.func_206870_a(property, (Comparable)property.func_185929_b(valueSplit[1]).get());
                    }
                    continue;
                }
                states.addAll(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(state))).func_176194_O().func_177619_a());
            }
            return states;
        }
    }

    public static class Serializer
    implements JsonDeserializer<MultiblockPattern> {
        public MultiblockPattern deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation itemId = new ResourceLocation(json.getAsJsonObject("catalyst").getAsJsonPrimitive("item").getAsString());
            ItemStack catalyst = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemId), 1);
            String[] shape = (String[])context.deserialize((JsonElement)json.getAsJsonArray("shape"), String[].class);
            Point origin = (Point)context.deserialize((JsonElement)json.getAsJsonObject("origin"), Point.class);
            Map definition = (Map)context.deserialize((JsonElement)json.getAsJsonObject("definition"), new TypeToken<Map<Character, Slot>>(){}.getType());
            return new MultiblockPattern(catalyst, shape, origin, definition);
        }
    }

    public static class Slot
    implements Predicate<BlockState> {
        @JsonAdapter(value=SerializerBlockState.class)
        private final Set<BlockState> states;

        public Slot(BlockState ... states) {
            this.states = Sets.newHashSet((Object[])states);
        }

        public Slot(Block block) {
            this((BlockState[])block.func_176194_O().func_177619_a().toArray((Object[])new BlockState[0]));
        }

        @Override
        public boolean test(BlockState state) {
            return this.states.contains(state);
        }
    }
}

