/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core.data;

import info.tehnut.soulshardsrespawn.api.IBinding;
import info.tehnut.soulshardsrespawn.api.IShardTier;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class Binding
implements IBinding,
INBTSerializable<CompoundNBT> {
    @Nullable
    private ResourceLocation boundEntity;
    @Nullable
    private UUID owner;
    private int kills;

    public Binding(ResourceLocation boundEntity, UUID owner, int kills) {
        this.boundEntity = boundEntity;
        this.owner = owner;
        this.kills = kills;
    }

    public Binding(ResourceLocation boundEntity, int kills) {
        this(boundEntity, null, kills);
    }

    public Binding(CompoundNBT bindingTag) {
        this.deserializeNBT(bindingTag);
    }

    @Override
    @Nullable
    public ResourceLocation getBoundEntity() {
        return this.boundEntity;
    }

    public Binding setBoundEntity(@Nullable ResourceLocation boundEntity) {
        this.boundEntity = boundEntity;
        return this;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public Binding setOwner(@Nullable UUID owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public int getKills() {
        return this.kills;
    }

    public Binding setKills(int kills) {
        this.kills = Math.min(Tier.maxKills, kills);
        return this;
    }

    @Override
    public Binding addKills(int kills) {
        this.kills = Math.min(Tier.maxKills, this.kills + kills);
        return this;
    }

    @Override
    public IShardTier getTier() {
        return Tier.TIERS.floorEntry(this.kills).getValue();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.boundEntity != null) {
            tag.func_74778_a("bound", this.boundEntity.toString());
        }
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
        tag.func_74768_a("kills", this.kills);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("bound")) {
            this.boundEntity = new ResourceLocation(nbt.func_74779_i("bound"));
        }
        if (nbt.func_186855_b("owner")) {
            this.owner = nbt.func_186857_a("owner");
        }
        this.kills = nbt.func_74762_e("kills");
    }

    @Nullable
    public static Binding fromNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b("binding")) {
            return null;
        }
        return new Binding(tag.func_74775_l("binding"));
    }
}

