/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.block;

import info.tehnut.soulshardsrespawn.block.TileEntitySoulCage;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockSoulCage
extends Block {
    public static final Property<Boolean> POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final Property<Boolean> ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public BlockSoulCage() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_200943_b(3.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!player.func_226271_bk_()) {
            return ActionResultType.PASS;
        }
        TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
        if (cage == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = cage.getInventory().extractItem(0, 1, false);
        if (stack.func_190926_b()) {
            return ActionResultType.PASS;
        }
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        return ActionResultType.SUCCESS;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState state2, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean someBool) {
        this.handleRedstoneChange(world, state, pos);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState blockState2, boolean someBool) {
        TileEntitySoulCage cage;
        if (this.hasTileEntity(state) && state.func_177230_c() != blockState2.func_177230_c() && (cage = (TileEntitySoulCage)world.func_175625_s(pos)) != null) {
            ItemStack stack = cage.getInventory().getStackInSlot(0);
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}));
        }
        super.func_196243_a(state, world, pos, blockState2, someBool);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
        if (cage == null) {
            return 0;
        }
        Binding binding = cage.getBinding();
        if (binding == null) {
            return 0;
        }
        return (int)((double)binding.getTier().getIndex() / ((double)Tier.INDEXED.size() - 1.0) * 15.0);
    }

    public boolean func_229869_c_(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED, ACTIVE});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntitySoulCage();
    }

    private void handleRedstoneChange(World world, BlockState state, BlockPos pos) {
        boolean powered = world.func_175640_z(pos);
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue() && !powered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a(POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.func_177229_b(POWERED)).booleanValue() && powered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a(POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

