/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.caelus.api;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class CaelusAPI {
    public static final IAttribute ELYTRA_FLIGHT = new RangedAttribute(null, "caelus.elytraFlight", 0.0, 0.0, 1.0).func_111112_a(true);
    public static final AttributeModifier ELYTRA_MODIFIER = new AttributeModifier(UUID.fromString("5b6c3728-9c24-42ae-83ac-70d61d8b8199"), "Elytra modifier", 1.0, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier DISABLE_FLIGHT = new AttributeModifier(UUID.fromString("faadb8f3-c95c-44ce-ba68-0f31bd1b47d5"), "Toggled modifier", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static List<Function<LivingEntity, ElytraRender>> renderFunctions = new ArrayList<Function<LivingEntity, ElytraRender>>();

    public static boolean canElytraFly(LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            ItemStack stack = livingEntity.func_184582_a(EquipmentSlotType.CHEST);
            return stack.func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d((ItemStack)stack);
        }
        return livingEntity.func_110148_a(ELYTRA_FLIGHT).func_111126_e() >= 1.0;
    }

    public static ElytraRender getElytraRender(LivingEntity livingEntity) {
        ElytraRender render = ElytraRender.NONE;
        for (Function<LivingEntity, ElytraRender> func : renderFunctions) {
            if (func.apply(livingEntity) == ElytraRender.NORMAL) {
                render = ElytraRender.NORMAL;
                continue;
            }
            if (func.apply(livingEntity) != ElytraRender.ENCHANTED) continue;
            return ElytraRender.ENCHANTED;
        }
        return render;
    }

    public static enum ElytraRender {
        NONE,
        NORMAL,
        ENCHANTED;

    }

    public static final class IMC {
        public static final String ELYTRA_RENDER = "elytraRender";
    }
}

