/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RecipesGui
extends Screen
implements IRecipesGui,
IShowsRecipeFocuses,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final RecipeTransferManager recipeTransferManager;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString = "1/1";
    private String title = "";
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final HoverChecker titleHoverChecker = new HoverChecker();
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IngredientManager ingredientManager) {
        super((ITextComponent)new StringTextComponent("Recipes"));
        this.recipeTransferManager = recipeTransferManager;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, ingredientManager);
        this.recipeCatalysts = new RecipeCatalysts();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.minecraft = Minecraft.func_71410_x();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getGuiBackground();
    }

    private static void drawCenteredStringWithShadow(FontRenderer font, String string, int guiWidth, int xOffset, int yPos, int color) {
        font.func_175063_a(string, (float)(guiWidth - font.func_78256_a(string)) / 2.0f + (float)xOffset, (float)yPos, color);
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.xSize = 198;
        this.ySize = this.height - 68;
        int extraSpace = 0;
        int maxHeight = ClientConfig.getInstance().getMaxRecipeGuiHeight();
        if (this.ySize > maxHeight) {
            extraSpace = this.ySize - maxHeight;
            this.ySize = maxHeight;
        }
        this.guiLeft = (width - this.xSize) / 2;
        this.guiTop = 45 + extraSpace / 2;
        int rightButtonX = this.guiLeft + this.xSize - 6 - 13;
        int leftButtonX = this.guiLeft + 6;
        this.font.getClass();
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = this.guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.x = rightButtonX;
        this.nextRecipeCategory.y = recipeClassButtonTop;
        this.previousRecipeCategory.x = leftButtonX;
        this.previousRecipeCategory.y = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.x = rightButtonX;
        this.nextPage.y = pageButtonTop;
        this.previousPage.x = leftButtonX;
        this.previousPage.y = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - this.guiTop;
        this.addButtons();
        this.init = true;
        this.updateLayout();
    }

    private void addButtons() {
        this.addButton((Widget)this.nextRecipeCategory);
        this.addButton((Widget)this.nextRecipeCategory);
        this.addButton((Widget)this.previousRecipeCategory);
        this.addButton((Widget)this.nextPage);
        this.addButton((Widget)this.previousPage);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.background.draw(this.guiLeft, this.guiTop, this.xSize, this.ySize);
        RenderSystem.disableBlend();
        RecipesGui.fill((int)(this.guiLeft + 6 + 13), (int)this.nextRecipeCategory.y, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nextRecipeCategory.y + 13), (int)0x30000000);
        RecipesGui.fill((int)(this.guiLeft + 6 + 13), (int)this.nextPage.y, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nextPage.y + 13), (int)0x30000000);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.font.getClass();
        int textPadding = (13 - 9) / 2;
        RecipesGui.drawCenteredStringWithShadow(this.font, this.title, this.xSize, this.guiLeft, this.nextRecipeCategory.y + textPadding, -1);
        RecipesGui.drawCenteredStringWithShadow(this.font, this.pageString, this.xSize, this.guiLeft, this.nextPage.y + textPadding, -1);
        this.nextRecipeCategory.render(mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.render(mouseX, mouseY, partialTicks);
        this.nextPage.render(mouseX, mouseY, partialTicks);
        this.previousPage.render(mouseX, mouseY, partialTicks);
        RecipeLayout hoveredLayout = null;
        for (RecipeLayout recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(mouseX, mouseY);
        }
        GuiIngredient hoveredRecipeCatalyst = this.recipeCatalysts.draw(mouseX, mouseY);
        this.recipeGuiTabs.draw(this.minecraft, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            String showAllRecipesString = Translator.translateToLocal("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(showAllRecipesString, mouseX, mouseY);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.minecraft != null && this.minecraft.field_71462_r == this) {
            if (mouseX >= (double)this.guiLeft && mouseY >= (double)this.guiTop && mouseX < (double)(this.guiLeft + this.xSize) && mouseY < (double)(this.guiTop + this.ySize)) {
                return true;
            }
            for (RecipeLayout recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                return clicked;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                for (RecipeLayout recipeLayouts : this.recipeLayouts) {
                    Object displayedIngredient;
                    GuiIngredient<?> clicked2 = recipeLayouts.getGuiIngredientUnderMouse(mouseX, mouseY);
                    if (clicked2 == null || (displayedIngredient = clicked2.getDisplayedIngredient()) == null) continue;
                    return ClickedIngredient.create(displayedIngredient, clicked2.getRect());
                }
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public boolean mouseScrolled(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.isMouseOver(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.mouseScrolled(scrollX, scrollY, scrollDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (RecipeLayout recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleClick(mouseX, mouseY, mouseButton)) continue;
                    return true;
                }
            }
        }
        if (this.recipeGuiTabs.isMouseOver(mouseX, mouseY) && this.recipeGuiTabs.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.handleKeybindings(input)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        return this.handleKeybindings(input);
    }

    private boolean handleKeybindings(InputMappings.Input input) {
        IngredientListOverlay itemListOverlay;
        if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isInventoryToggleKey(input)) {
            this.onClose();
            return true;
        }
        if (KeyBindings.recipeBack.isActiveAndMatches(input)) {
            this.back();
            return true;
        }
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && !(itemListOverlay = runtime.getIngredientListOverlay()).isMouseOver(MouseUtil.getX(), MouseUtil.getY())) {
            if (KeyBindings.nextPage.isActiveAndMatches(input)) {
                this.logic.nextPage();
                return true;
            }
            if (KeyBindings.previousPage.isActiveAndMatches(input)) {
                this.logic.previousPage();
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return this.minecraft != null && this.minecraft.field_71462_r == this;
    }

    private void open() {
        if (this.minecraft != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.minecraft.field_71462_r;
            }
            this.minecraft.func_147108_a((Screen)this);
        }
    }

    public void onClose() {
        if (this.isOpen() && this.minecraft != null) {
            if (this.parentScreen != null) {
                this.minecraft.func_147108_a(this.parentScreen);
                this.parentScreen = null;
            } else {
                ClientPlayerEntity player = this.minecraft.field_71439_g;
                if (player != null) {
                    player.func_71053_j();
                }
            }
            this.logic.clearHistory();
        }
    }

    @Override
    public <V> void show(IFocus<V> focus) {
        Focus<V> checkedFocus = Focus.check(focus);
        if (this.logic.setFocus(checkedFocus)) {
            this.open();
        }
    }

    @Override
    public void showCategories(List<ResourceLocation> recipeCategoryUids) {
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IClickedIngredient<?> ingredient = this.getIngredientUnderMouse(MouseUtil.getX(), MouseUtil.getY());
        if (ingredient != null) {
            return ingredient.getValue();
        }
        return null;
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        int availableHeight = this.ySize - this.headerHeight;
        IRecipeCategory recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int heightPerRecipe = recipeBackground.getHeight() + 14;
        int recipesPerPage = availableHeight / heightPerRecipe;
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = this.guiLeft + (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.font.func_78256_a(this.title);
        int availableTitleWidth = this.nextPage.x - (this.previousPage.x + this.previousPage.getWidth()) - 28;
        if (titleWidth > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.font);
            titleWidth = this.font.func_78256_a(this.title);
        }
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 6;
        this.font.getClass();
        this.titleHoverChecker.updateBounds(titleY, titleY + 9, titleX, titleX + titleWidth);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, this.guiTop + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.active = this.previousPage.active = this.logic.hasMultiplePages();
        this.nextRecipeCategory.active = this.previousRecipeCategory.active = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<Object> recipeCatalysts = this.logic.getRecipeCatalysts();
        this.recipeCatalysts.updateLayout(recipeCatalysts, this);
        this.recipeGuiTabs.initLayout(this);
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.children.removeAll(this.buttons);
        this.buttons.clear();
        this.addButtons();
        if (this.minecraft == null) {
            return;
        }
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        Container container = this.getParentContainer();
        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.init(this.recipeTransferManager, container, (PlayerEntity)player);
            button.setOnClickHandler((arg_0, arg_1) -> this.lambda$addRecipeTransferButtons$4(container, recipeLayout, (PlayerEntity)player, arg_0, arg_1));
            this.addButton((Widget)button);
        }
    }

    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof ContainerScreen) {
            return ((ContainerScreen)this.parentScreen).func_212873_a_();
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$4(Container container, RecipeLayout recipeLayout, PlayerEntity player, double mouseX, double mouseY) {
        boolean maxTransfer = Screen.hasShiftDown();
        if (container != null && RecipeTransferUtil.transferRecipe(this.recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
            this.onClose();
        }
    }
}

