/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xreliquary.api.IPedestal;
import xreliquary.client.render.PedestalFishHookRenderer;
import xreliquary.util.WorldHelper;

public class PacketPedestalFishHook {
    private BlockPos pedestalPos;
    private double hookX;
    private double hookY;
    private double hookZ;

    public PacketPedestalFishHook(BlockPos pedestalPos, double hookX, double hookY, double hookZ) {
        this.pedestalPos = pedestalPos;
        this.hookX = hookX;
        this.hookY = hookY;
        this.hookZ = hookZ;
    }

    static void encode(PacketPedestalFishHook msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.pedestalPos.func_177958_n());
        packetBuffer.writeInt(msg.pedestalPos.func_177956_o());
        packetBuffer.writeInt(msg.pedestalPos.func_177952_p());
        packetBuffer.writeDouble(msg.hookX);
        packetBuffer.writeDouble(msg.hookY);
        packetBuffer.writeDouble(msg.hookZ);
    }

    static PacketPedestalFishHook decode(PacketBuffer packetBuffer) {
        return new PacketPedestalFishHook(new BlockPos(packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readInt()), packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
    }

    static void onMessage(PacketPedestalFishHook msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketPedestalFishHook.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketPedestalFishHook message) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        WorldHelper.getTile((IBlockReader)world, message.pedestalPos, IPedestal.class).ifPresent(pedestal -> {
            PedestalFishHookRenderer.HookRenderingData data = null;
            if (message.hookY > 0.0) {
                data = new PedestalFishHookRenderer.HookRenderingData(message.hookX, message.hookY, message.hookZ);
            }
            pedestal.setItemData(data);
        });
    }
}

