/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import xreliquary.entities.EnderStaffProjectileEntity;
import xreliquary.init.ModBlocks;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.FilteredBigItemStack;
import xreliquary.items.util.FilteredItemHandlerProvider;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class EnderStaffItem
extends ToggleableItem
implements ILeftClickableItem {
    private static final String DIMENSION_ID_TAG = "dimensionID";
    private static final String NODE_X_TAG = "nodeX";
    private static final String NODE_Y_TAG = "nodeY";
    private static final String NODE_Z_TAG = "nodeZ";
    private static final String LONG_CAST_TAG = "long_cast";

    public EnderStaffItem() {
        super("ender_staff", new Item.Properties().func_200917_a(1).setNoRepair().func_208103_a(Rarity.EPIC));
    }

    private int getEnderStaffPearlCost() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlCastCost.get();
    }

    private int getEnderStaffNodeWarpCost() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlNodeWarpCost.get();
    }

    private int getEnderPearlWorth() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlWorth.get();
    }

    private int getEnderPearlLimit() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlLimit.get();
    }

    private int getNodeWarpCastTime() {
        return (Integer)Settings.COMMON.items.enderStaff.nodeWarpCastTime.get();
    }

    public String getMode(ItemStack stack) {
        if (NBTHelper.getString("mode", stack).equals("")) {
            this.setMode(stack, "cast");
        }
        return NBTHelper.getString("mode", stack);
    }

    private void setMode(ItemStack stack, String s) {
        NBTHelper.putString("mode", stack, s);
    }

    private void cycleMode(ItemStack stack) {
        if (this.getMode(stack).equals("cast")) {
            this.setMode(stack, LONG_CAST_TAG);
        } else if (this.getMode(stack).equals(LONG_CAST_TAG)) {
            this.setMode(stack, "node_warp");
        } else {
            this.setMode(stack, "cast");
        }
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack stack, LivingEntity entity) {
        if (!entity.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entity.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleMode(stack);
        return ActionResultType.SUCCESS;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FilteredItemHandlerProvider(Collections.singletonList(new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(Items.field_151079_bi, (int)((Integer)Settings.COMMON.items.enderStaff.enderPearlLimit.get()), (int)((Integer)Settings.COMMON.items.enderStaff.enderPearlWorth.get())), false)));
    }

    public void func_77663_a(ItemStack staff, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null) {
            return;
        }
        if (!this.isEnabled(staff)) {
            return;
        }
        if (this.getPearlCount(staff) + this.getEnderPearlWorth() <= this.getEnderPearlLimit() && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_151079_bi), player)) {
            this.setPearlCount(staff, this.getPearlCount(staff) + this.getEnderPearlWorth());
        }
    }

    private void setPearlCount(ItemStack stack, int count) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> {
            if (!(itemHandler instanceof FilteredItemStackHandler)) {
                return;
            }
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
            filteredHandler.setTotalAmount(0, count);
        });
    }

    private int getPearlCount(ItemStack staff) {
        return this.getPearlCount(staff, false);
    }

    public int getPearlCount(ItemStack staff, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInt("count", staff);
        }
        return (Integer)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> {
            if (!(itemHandler instanceof FilteredItemStackHandler)) {
                return 0;
            }
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
            return filteredHandler.getTotalAmount(0);
        }).orElse((Object)0);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLivingBase, int unadjustedCount) {
        if (!(entityLivingBase instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLivingBase;
        for (int particles = 0; particles < 2; ++particles) {
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian());
        }
        if (unadjustedCount == 1) {
            player.func_184597_cx();
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getNodeWarpCastTime();
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (timeLeft == 1) {
            this.doWraithNodeWarpCheck(stack, player.field_70170_p, player);
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            if (this.getMode(stack).equals("cast") || this.getMode(stack).equals(LONG_CAST_TAG)) {
                if (player.field_82175_bq || this.getPearlCount(stack) < this.getEnderStaffPearlCost() && !player.func_184812_l_()) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                player.func_184609_a(hand);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187595_bc, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_70170_p.field_72995_K) {
                    EnderStaffProjectileEntity enderStaffProjectile = new EnderStaffProjectileEntity(player.field_70170_p, player, !this.getMode(stack).equals(LONG_CAST_TAG));
                    enderStaffProjectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                    player.field_70170_p.func_217376_c((Entity)enderStaffProjectile);
                    if (!player.func_184812_l_()) {
                        this.setPearlCount(stack, this.getPearlCount(stack) - this.getEnderStaffPearlCost());
                    }
                }
            } else {
                player.func_184598_c(hand);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private void doWraithNodeWarpCheck(ItemStack stack, World world, PlayerEntity player) {
        if (this.getPearlCount(stack) < this.getEnderStaffNodeWarpCost() && !player.func_184812_l_()) {
            return;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e(DIMENSION_ID_TAG) != this.getDimension(world)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Out of range!"));
            }
        } else if (stack.func_77978_p() != null && world.func_180495_p(new BlockPos(stack.func_77978_p().func_74762_e(NODE_X_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Y_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Z_TAG + this.getDimension(world)))).func_177230_c() == ModBlocks.WRAITH_NODE) {
            if (this.canTeleport(world, stack.func_77978_p().func_74762_e(NODE_X_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Y_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Z_TAG + this.getDimension(world)))) {
                this.teleportPlayer(world, stack.func_77978_p().func_74762_e(NODE_X_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Y_TAG + this.getDimension(world)), stack.func_77978_p().func_74762_e(NODE_Z_TAG + this.getDimension(world)), player);
                if (!player.func_184812_l_() && !player.field_70170_p.field_72995_K) {
                    this.setPearlCount(stack, this.getPearlCount(stack) - this.getEnderStaffNodeWarpCost());
                }
            }
        } else if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(DIMENSION_ID_TAG)) {
            stack.func_77978_p().func_82580_o(DIMENSION_ID_TAG);
            stack.func_77978_p().func_82580_o(NODE_X_TAG);
            stack.func_77978_p().func_82580_o(NODE_Y_TAG);
            stack.func_77978_p().func_82580_o(NODE_Z_TAG);
            stack.func_77978_p().func_82580_o("cooldown");
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Node dosen't exist!"));
            } else {
                player.func_184185_a(SoundEvents.field_187530_aT, 1.0f, 1.0f);
            }
        }
    }

    private boolean canTeleport(World world, int x, int y, int z) {
        return world.func_175623_d(new BlockPos(x, y + 1, z)) && world.func_175623_d(new BlockPos(x, y + 2, z));
    }

    private void teleportPlayer(World world, int x, int y, int z, PlayerEntity player) {
        player.func_70634_a((double)x + 0.5, (double)y + 0.875, (double)z + 0.5);
        player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<ITextComponent> tooltip) {
        String charge = Integer.toString(this.getPearlCount(staff, true));
        String phrase = "Currently bound to ";
        String position = "";
        if (staff.func_77978_p() != null && staff.func_77978_p().func_74762_e(DIMENSION_ID_TAG) != this.getDimension(world)) {
            phrase = "Out of range!";
        } else {
            position = staff.func_77978_p() != null && staff.func_77978_p().func_74764_b(NODE_X_TAG + this.getDimension(world)) && staff.func_77978_p().func_74764_b(NODE_Y_TAG + this.getDimension(world)) && staff.func_77978_p().func_74764_b(NODE_Z_TAG + this.getDimension(world)) ? "X: " + staff.func_77978_p().func_74762_e(NODE_X_TAG + this.getDimension(world)) + " Y: " + staff.func_77978_p().func_74762_e(NODE_Y_TAG + this.getDimension(world)) + " Z: " + staff.func_77978_p().func_74762_e(NODE_Z_TAG + this.getDimension(world)) : "nowhere.";
        }
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"position", (Object)position, (Object)"charge", (Object)charge), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + Items.field_151079_bi.func_200295_i(new ItemStack((IItemProvider)Items.field_151079_bi)).toString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        ItemStack stack = itemUseContext.func_195996_i();
        World world = itemUseContext.func_195991_k();
        BlockPos pos = itemUseContext.func_195995_a();
        if (!(stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(DIMENSION_ID_TAG) || world.func_180495_p(pos).func_177230_c() != ModBlocks.WRAITH_NODE)) {
            this.setWraithNode(stack, pos, this.getDimension(world));
            PlayerEntity player = itemUseContext.func_195999_j();
            if (player != null) {
                player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            for (int particles = 0; particles < 12; ++particles) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private int getDimension(@Nullable World world) {
        return world != null ? world.func_201675_m().func_186058_p().func_186068_a() : 0;
    }

    private void setWraithNode(ItemStack eye, BlockPos pos, int dimensionID) {
        NBTHelper.putInt(NODE_X_TAG + dimensionID, eye, pos.func_177958_n());
        NBTHelper.putInt(NODE_Y_TAG + dimensionID, eye, pos.func_177956_o());
        NBTHelper.putInt(NODE_Z_TAG + dimensionID, eye, pos.func_177952_p());
        NBTHelper.putInt(DIMENSION_ID_TAG, eye, dimensionID);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack staff) {
        CompoundNBT nbt = super.getShareTag(staff);
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("count", this.getPearlCount(staff));
        return nbt;
    }
}

