/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.items.PhoenixDownItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;

public class AngelicFeatherItem
extends ItemBase {
    public AngelicFeatherItem() {
        this("angelic_feather");
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_76379_h && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, ModItems.ANGELIC_FEATHER) && player.field_70143_R > 0.0f;
            }

            @Override
            public boolean apply(PlayerEntity player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.angelicFeather.hungerCostPercent.get()).intValue() / 100.0f);
                player.func_71020_j(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    AngelicFeatherItem(String name) {
        super(name, new Item.Properties().func_200917_a(1).setNoRepair().func_208103_a(Rarity.EPIC));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int potency;
        int n = potency = this instanceof PhoenixDownItem ? ((Integer)Settings.COMMON.items.phoenixDown.leapingPotency.get()).intValue() : ((Integer)Settings.COMMON.items.angelicFeather.leapingPotency.get()).intValue();
        if (potency == 0) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_195064_c(new EffectInstance(Effects.field_76430_j, 2, potency, true, false));
        }
    }
}

