/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class StormShotEntity
extends ShotEntityBase {
    public StormShotEntity(EntityType<StormShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public StormShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.STORM_SHOT, world, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    void doFlightEffects() {
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos pos = blockResult.func_216350_a().func_177972_a(blockResult.func_216354_b());
            if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_175727_C(pos) && this.field_70170_p.func_72912_H().func_76059_o() && this.field_70170_p.func_72912_H().func_76061_m()) {
                ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
            }
        }
        super.onImpact(result);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        Vec3d motion = this.func_213322_ci();
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.gaussian(motion.func_82615_a()), (double)this.field_70146_Z.nextFloat() + motion.func_82617_b(), this.gaussian(motion.func_82616_c()));
        }
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    int getDamageOfShot(LivingEntity entity) {
        if (entity instanceof CreeperEntity) {
            entity.func_70077_a(new LightningBoltEntity(this.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), false));
        }
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_175727_C(new BlockPos((int)(entity.func_226277_ct_() + 0.5), (int)(entity.func_226278_cu_() + 0.5), (int)(entity.func_226281_cx_() + 0.5))) && this.field_70170_p.func_72912_H().func_76059_o() && this.field_70170_p.func_72912_H().func_76061_m()) {
            ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, (double)((int)(entity.func_226277_ct_() + 0.5)), (double)((int)(entity.func_226278_cu_() + 0.5)), (double)((int)(entity.func_226281_cx_() + 0.5)), false));
        }
        float f = 1.0f + (this.field_70170_p.func_72896_J() ? 0.5f : 0.0f) + (this.field_70170_p.func_72911_I() ? 0.5f : 0.0f);
        return Math.round(9.0f * f) + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.STORM;
    }
}

