/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.util.potions.XRPotionHelper;

public class XRTippedArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(ArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private List<EffectInstance> effects = Lists.newArrayList();

    public XRTippedArrowEntity(EntityType<XRTippedArrowEntity> entityType, World world) {
        super(entityType, world);
    }

    public XRTippedArrowEntity(World world, double x, double y, double z) {
        super(ModEntities.TIPPED_ARROW, x, y, z, world);
    }

    public XRTippedArrowEntity(World world, LivingEntity shooter) {
        super(ModEntities.TIPPED_ARROW, shooter, world);
    }

    public void setPotionEffect(ItemStack stack) {
        this.effects = XRPotionHelper.getPotionEffectsFromStack(stack);
        this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.effects));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.effects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.effects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)0);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != 0 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.effects);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
        if (!this.effects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.effects));
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        Entity shooter = this.func_212360_k();
        if (shooter != null) {
            XRPotionHelper.applyEffectsToEntity(this.effects, (Entity)this, this.func_212360_k(), living);
        }
    }

    protected ItemStack func_184550_j() {
        if (this.effects.isEmpty()) {
            return new ItemStack((IItemProvider)Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack((IItemProvider)ModItems.TIPPED_ARROW);
        XRPotionHelper.addPotionEffectsToStack(itemstack, this.effects);
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

