/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.client.gui.components.TextPane;
import xreliquary.client.gui.components.XPBarPane;
import xreliquary.init.ModItems;
import xreliquary.reference.Colors;
import xreliquary.util.InventoryHelper;
import xreliquary.util.XpHelper;

public class HeroMedallionPane
extends Component {
    private XPBarPane xpBar = new XPBarPane();
    private TextPane levelPane = new TextPane("0", Colors.get("009900"));
    private Box mainPane = Box.createVertical(Box.Alignment.RIGHT, this.xpBar, Box.createHorizontal(Box.Alignment.MIDDLE, new ItemStackPane(ModItems.HERO_MEDALLION), this.levelPane));

    @Override
    public int getHeightInternal() {
        return this.mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPane.getWidth();
    }

    @Override
    public boolean shouldRender() {
        return !InventoryHelper.getCorrectItemFromEitherHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModItems.HERO_MEDALLION).func_190926_b();
    }

    @Override
    public int getPadding() {
        return 1;
    }

    @Override
    public void renderInternal(int x, int y) {
        ItemStack item = InventoryHelper.getCorrectItemFromEitherHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModItems.HERO_MEDALLION);
        if (item.func_190926_b()) {
            return;
        }
        int experience = ModItems.HERO_MEDALLION.getExperience(item);
        int level = XpHelper.getLevelForExperience(experience);
        this.levelPane.setText(String.valueOf(level));
        int remainingExperience = experience - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        float xpRatio = (float)remainingExperience / (float)maxBarExperience;
        this.xpBar.setXpRatio(xpRatio);
        this.mainPane.render(x, y);
    }
}

