/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import xreliquary.blocks.ApothecaryCauldronBlock;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.client.init.ModParticles;
import xreliquary.client.particle.ColorParticleData;
import xreliquary.compat.waila.provider.IWailaDataChangeIndicator;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.PotionEssenceItem;
import xreliquary.reference.Settings;
import xreliquary.util.InjectionHelper;
import xreliquary.util.potions.XRPotionHelper;

public class ApothecaryCauldronTileEntity
extends TileEntityBase
implements IWailaDataChangeIndicator,
ITickableTileEntity {
    @ObjectHolder(value="xreliquary:apothecary_cauldron")
    public static final TileEntityType<ApothecaryCauldronTileEntity> TYPE = (TileEntityType)InjectionHelper.nullValue();
    private int redstoneCount = 0;
    private List<EffectInstance> effects = Lists.newArrayList();
    private int glowstoneCount = 0;
    private boolean hasGunpowder = false;
    private boolean hasNetherwart = false;
    private boolean hasDragonBreath = false;
    private int cookTime = 0;
    private int liquidLevel = 0;
    private boolean dataChanged = true;

    public ApothecaryCauldronTileEntity() {
        super(TYPE);
    }

    public void func_73660_a() {
        if (this.getHeatSources().contains(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, 0)).func_177230_c()) && this.getLiquidLevel() > 0) {
            if (!this.effects.isEmpty() && this.hasNetherwart && this.cookTime < this.getTotalCookTime()) {
                ++this.cookTime;
            }
            if (this.field_145850_b.field_72995_K) {
                for (int particleCount = 0; particleCount <= 2; ++particleCount) {
                    this.spawnBoilingParticles();
                }
                if (this.hasDragonBreath) {
                    this.spawnDragonBreathParticles();
                } else if (this.hasGunpowder) {
                    this.spawnGunpowderParticles();
                }
                if (this.glowstoneCount > 0) {
                    this.spawnGlowstoneParticles();
                }
                if (this.hasNetherwart) {
                    this.spawnNetherwartParticles();
                    if (this.finishedCooking()) {
                        this.spawnFinishedParticles();
                    }
                }
                if (this.redstoneCount > 0) {
                    this.spawnRedstoneParticles();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnBoilingParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(this.getTotalCookTime() * this.getTotalCookTime()) > this.cookTime * this.cookTime) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        int color = PotionUtils.func_185181_a(this.effects);
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        ColorParticleData particleData = new ColorParticleData(ModParticles.CAULDRON_BUBBLE, red, green, blue);
        this.field_145850_b.func_195594_a((IParticleData)particleData, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)this.func_174877_v().func_177956_o() + 0.01 + (double)this.getRenderLiquidLevel(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
        particleData = new ColorParticleData(ModParticles.CAULDRON_STEAM, red, green, blue);
        if (this.field_145850_b.field_73012_v.nextInt(6) == 0) {
            this.field_145850_b.func_195594_a((IParticleData)particleData, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)this.func_174877_v().func_177956_o() + 0.01 + (double)this.getRenderLiquidLevel(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.05 + (double)(0.02f * this.getRenderLiquidLevel()), 0.0);
        }
    }

    private float getRenderLiquidLevel() {
        int j = MathHelper.func_76125_a((int)this.getLiquidLevel(), (int)0, (int)3);
        return (float)(6 + 3 * j) / 16.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGunpowderParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnDragonBreathParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197616_i, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGlowstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, gauss, gauss, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnNetherwartParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, gauss, 0.0, gauss);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnRedstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(10) / this.redstoneCount > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 1.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFinishedParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197607_R, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)xOffset, (double)((float)this.func_174877_v().func_177956_o() + this.getRenderLiquidLevel()), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.setLiquidLevel(tag.func_74765_d("liquidLevel"));
        this.glowstoneCount = tag.func_74762_e("glowstoneCount");
        this.hasNetherwart = tag.func_74767_n("hasNetherwart");
        this.hasGunpowder = tag.func_74767_n("hasGunpowder");
        this.hasDragonBreath = tag.func_74767_n("hasDragonBreath");
        this.redstoneCount = tag.func_74762_e("redstoneCount");
        this.cookTime = tag.func_74762_e("cookTime");
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("liquidLevel", this.getLiquidLevel());
        compound.func_74768_a("cookTime", this.cookTime);
        compound.func_74768_a("redstoneCount", this.redstoneCount);
        compound.func_74768_a("glowstoneCount", this.glowstoneCount);
        compound.func_74757_a("hasGunpowder", this.hasGunpowder);
        compound.func_74757_a("hasDragonBreath", this.hasDragonBreath);
        compound.func_74757_a("hasNetherwart", this.hasNetherwart);
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.effects);
        return compound;
    }

    private boolean finishedCooking() {
        return this.hasNetherwart && !this.effects.isEmpty() && this.cookTime >= this.getTotalCookTime() && (!this.hasDragonBreath || this.hasGunpowder);
    }

    private ItemStack removeContainedPotion() {
        ItemStack potion = this.hasDragonBreath ? new ItemStack((IItemProvider)ModItems.LINGERING_POTION) : (this.hasGunpowder ? new ItemStack((IItemProvider)ModItems.SPLASH_POTION) : new ItemStack((IItemProvider)ModItems.POTION));
        XRPotionHelper.addPotionEffectsToStack(potion, XRPotionHelper.augmentPotionEffects(this.effects, this.redstoneCount, this.glowstoneCount));
        this.setLiquidLevel(this.getLiquidLevel() - 1);
        if (this.getLiquidLevel() <= 0) {
            this.clearAllFields();
        }
        return potion;
    }

    private void clearAllFields() {
        this.cookTime = 0;
        this.glowstoneCount = 0;
        this.hasGunpowder = false;
        this.hasNetherwart = false;
        this.redstoneCount = 0;
        this.effects.clear();
        this.dataChanged = true;
        this.hasDragonBreath = false;
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    private boolean isItemValidForInput(ItemStack stack) {
        if (stack.func_77973_b() instanceof PotionEssenceItem && this.effects.isEmpty()) {
            return true;
        }
        if (this.effects.isEmpty()) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151016_H && !this.hasGunpowder) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151114_aO && this.glowstoneCount < this.getGlowstoneAmpLimit()) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151137_ax && this.redstoneCount < this.getRedstoneAmpLimit()) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151075_bm && !this.hasNetherwart) {
            return true;
        }
        return stack.func_77973_b() == Items.field_185157_bK && !this.hasDragonBreath;
    }

    private void addItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof PotionEssenceItem) {
            this.effects = XRPotionHelper.getPotionEffectsFromStack(stack);
        } else if (stack.func_77973_b() == Items.field_151016_H) {
            this.hasGunpowder = true;
        } else if (stack.func_77973_b() == Items.field_151114_aO) {
            ++this.glowstoneCount;
        } else if (stack.func_77973_b() == Items.field_151137_ax) {
            ++this.redstoneCount;
        } else if (stack.func_77973_b() == Items.field_151075_bm) {
            this.hasNetherwart = true;
        } else if (stack.func_77973_b() == Items.field_185157_bK) {
            this.hasDragonBreath = true;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    private int getGlowstoneAmpLimit() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.glowstoneLimit.get();
    }

    private int getRedstoneAmpLimit() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.redstoneLimit.get();
    }

    private Set<Block> getHeatSources() {
        HashSet<Block> heatSources = new HashSet<Block>();
        List heatSourceBlockNames = (List)Settings.COMMON.blocks.apothecaryCauldron.heatSources.get();
        heatSourceBlockNames.forEach(blockName -> heatSources.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))));
        heatSources.add(Blocks.field_150353_l);
        heatSources.add(Blocks.field_150480_ab);
        return heatSources;
    }

    private int getTotalCookTime() {
        return (Integer)Settings.COMMON.blocks.apothecaryCauldron.cookTime.get();
    }

    public void handleCollidingEntity(World world, BlockPos pos, Entity collidingEntity) {
        int l = this.getLiquidLevel();
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * l)) / 16.0f;
        if (collidingEntity.func_174813_aQ().field_72338_b <= (double)f) {
            if (collidingEntity.func_70027_ad() && l > 0) {
                collidingEntity.func_70066_B();
            }
            if (collidingEntity instanceof LivingEntity) {
                if (this.effects.isEmpty()) {
                    return;
                }
                if (this.finishedCooking()) {
                    for (EffectInstance effect : this.effects) {
                        Effect potion = effect.func_188419_a();
                        if (potion.func_76403_b() && world.func_82737_E() % 20L != 0L) continue;
                        EffectInstance reducedEffect = new EffectInstance(effect.func_188419_a(), potion.func_76403_b() ? 1 : effect.func_76459_b() / 20, Math.max(0, effect.func_76458_c() - 1));
                        ((LivingEntity)collidingEntity).func_195064_c(reducedEffect);
                    }
                }
                if (this.cookTime > 0 && world.func_82737_E() % 10L == 0L) {
                    collidingEntity.func_70097_a(DamageSource.field_76372_a, 1.0f);
                }
            }
            if (collidingEntity instanceof ItemEntity) {
                ItemStack item = ((ItemEntity)collidingEntity).func_92059_d();
                while (this.isItemValidForInput(item)) {
                    this.addItem(item);
                    item.func_190918_g(1);
                }
            }
        }
    }

    public int getColorMultiplier() {
        return PotionUtils.func_185181_a(this.effects);
    }

    public int getLiquidLevel() {
        return this.liquidLevel;
    }

    public void fillWithRain() {
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            this.setLiquidLevel(this.getLiquidLevel() + 1);
        }
    }

    public ActionResultType handleBlockActivation(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return ActionResultType.CONSUME;
        }
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            if (itemStack.func_77973_b() == Items.field_151131_as) {
                if (!player.func_184812_l_()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
            } else if (Boolean.FALSE.equals(itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).map(fh -> this.drainWater(player, (IFluidHandlerItem)fh)).orElse((Object)false))) {
                return ActionResultType.CONSUME;
            }
            this.setLiquidLevel(3);
            this.cookTime = 0;
            return ActionResultType.SUCCESS;
        }
        if (itemStack.func_77973_b() == ModItems.EMPTY_POTION_VIAL && this.finishedCooking() && this.getLiquidLevel() > 0) {
            if (this.finishedCooking() && this.hasNetherwart && !this.effects.isEmpty() && this.getLiquidLevel() > 0) {
                ItemStack potion = this.removeContainedPotion();
                itemStack.func_190918_g(1);
                if (itemStack.func_190916_E() <= 0) {
                    player.func_184611_a(hand, potion);
                } else if (!player.field_71071_by.func_70441_a(potion)) {
                    world.func_217376_c((Entity)new ItemEntity(world, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, potion));
                }
                return ActionResultType.SUCCESS;
            }
        } else if (this.getLiquidLevel() == 3 && this.isItemValidForInput(itemStack)) {
            this.addItem(itemStack);
            if (itemStack.func_77973_b() == Items.field_185157_bK && (Integer)xreliquary.util.InventoryHelper.getItemHandlerFrom(player).map(handler -> xreliquary.util.InventoryHelper.tryToAddToInventory(new ItemStack((IItemProvider)Items.field_151069_bo), handler, 1)).orElse((Object)0) != 1) {
                InventoryHelper.func_180173_a((World)world, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (ItemStack)new ItemStack((IItemProvider)Items.field_151069_bo));
            }
            itemStack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    private Boolean drainWater(PlayerEntity player, IFluidHandlerItem fh) {
        FluidStack waterStack = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        if (!waterStack.equals((Object)fh.drain(waterStack, IFluidHandler.FluidAction.SIMULATE))) {
            return false;
        }
        if (!player.func_184812_l_()) {
            fh.drain(waterStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    private void setLiquidLevel(int liquidLevel) {
        this.liquidLevel = liquidLevel;
        if (this.field_145850_b != null) {
            BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            blockState = (BlockState)blockState.func_206870_a((IProperty)ApothecaryCauldronBlock.LEVEL, (Comparable)Integer.valueOf(liquidLevel));
            this.field_145850_b.func_175656_a(this.func_174877_v(), blockState);
            this.field_145850_b.func_175666_e(this.field_174879_c, (Block)ModBlocks.APOTHECARY_CAULDRON);
        }
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.dataChanged = true;
    }
}

