/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xreliquary.blocks.BaseBlock;
import xreliquary.blocks.tile.ApothecaryMortarTileEntity;
import xreliquary.init.ModItems;
import xreliquary.util.InventoryHelper;
import xreliquary.util.WorldHelper;

public class ApothecaryMortarBlock
extends BaseBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape MORTAR_SHAPE = ApothecaryMortarBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);

    public ApothecaryMortarBlock() {
        super("apothecary_mortar", Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 2.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return MORTAR_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ApothecaryMortarTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof ApothecaryMortarTileEntity)) {
            return ActionResultType.FAIL;
        }
        ApothecaryMortarTileEntity mortar = (ApothecaryMortarTileEntity)tileEntity;
        if (heldItem.func_190926_b()) {
            if (player.func_213453_ef()) {
                InventoryHelper.getItemHandlerFrom(mortar).ifPresent(itemHandler -> InventoryHelper.tryRemovingLastStack(itemHandler, world, mortar.func_174877_v()));
                return ActionResultType.SUCCESS;
            }
            boolean done = mortar.usePestle();
            world.func_184133_a(null, pos, this.field_149762_H.func_185844_d(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
            player.func_184609_a(hand);
            return done ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (mortar.isInCooldown() && heldItem.func_77973_b() == ModItems.POTION_ESSENCE) {
            return ActionResultType.CONSUME;
        }
        ItemStack stackToAdd = heldItem.func_77946_l();
        stackToAdd.func_190920_e(1);
        boolean putItemInSlot = (Boolean)InventoryHelper.getItemHandlerFrom(mortar).map(itemHandler -> {
            if (InventoryHelper.insertIntoInventory(stackToAdd, itemHandler) == 1) {
                heldItem.func_190918_g(1);
                return true;
            }
            return false;
        }).orElse((Object)false);
        if (!putItemInSlot) {
            mortar.usePestle();
            world.func_184133_a(null, pos, this.field_149762_H.func_185844_d(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
            return ActionResultType.CONSUME;
        }
        mortar.func_70296_d();
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j() == null) {
            return this.func_176223_P();
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195999_j().func_174811_aO());
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getTile((IBlockReader)world, pos, ApothecaryMortarTileEntity.class).ifPresent(ApothecaryMortarTileEntity::dropItems);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }
}

