/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.PathTypeAdapter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.TypeAdapter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public final class TypeAdapters {
    private static final Map<Class<?>, TypeAdapter> ADAPTERS;
    private static final List<Consumer<Class<?>>> AUTO_REGISTRARS;

    public static TypeAdapter get(Class<?> clazz) {
        TypeAdapter adapter = ADAPTERS.get(clazz);
        if (adapter != null) {
            return adapter;
        }
        AUTO_REGISTRARS.forEach(registrar -> registrar.accept(clazz));
        return ADAPTERS.get(clazz);
    }

    public static void register(Class<?> clazz, TypeAdapter adapter) {
        ADAPTERS.put(clazz, adapter);
    }

    public static void register(Class<?> clazz1, Class<?> clazz2, TypeAdapter adapter) {
        TypeAdapters.register(clazz1, adapter);
        TypeAdapters.register(clazz2, adapter);
    }

    public static void registerAutoRegistrar(Consumer<Class<?>> autoRegistrar) {
        AUTO_REGISTRARS.add(autoRegistrar);
    }

    private static <T> TypeAdapter getArrayAdapter(final Function<List<T>, Object> toArray) {
        return new TypeAdapter(){

            @Override
            public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
                return toArray.apply(config.get(name));
            }

            @Override
            public boolean isArray() {
                return true;
            }
        };
    }

    private static <N extends Number> TypeAdapter getNumberAdapter(final Function<String, N> parser) {
        return new TypeAdapter(){

            @Override
            public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
                try {
                    return parser.apply(config.get(name).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        };
    }

    private static <N extends Number> TypeAdapter getNumberArrayAdapter(Class<N> numberClass, final Function<Number, N> converter, final Function<Stream<N>, Object> toArray) {
        return new TypeAdapter(){

            @Override
            public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
                return toArray.apply(((List)config.get(name)).stream().map(number -> {
                    try {
                        return (Number)converter.apply(Double.parseDouble(number.toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }).filter(Objects::nonNull));
            }

            @Override
            public boolean isArray() {
                return true;
            }
        };
    }

    static {
        Class[] defaultAdapterClasses;
        ADAPTERS = new HashMap();
        AUTO_REGISTRARS = new ArrayList();
        for (Class clazz : defaultAdapterClasses = new Class[]{Boolean.TYPE, Boolean.class, Character.TYPE, Character.class}) {
            TypeAdapters.register(clazz, new TypeAdapter(){});
        }
        TypeAdapters.register(boolean[].class, TypeAdapters.getArrayAdapter(list -> ArrayUtils.toPrimitive((Boolean[])list.toArray(new Boolean[0]))));
        TypeAdapters.register(Boolean[].class, TypeAdapters.getArrayAdapter(list -> list.toArray(new Boolean[0])));
        TypeAdapters.register(Byte.TYPE, Byte.class, TypeAdapters.getNumberAdapter(Byte::parseByte));
        TypeAdapters.register(byte[].class, TypeAdapters.getNumberArrayAdapter(Byte.class, Number::byteValue, stream -> ArrayUtils.toPrimitive((Byte[])((Byte[])stream.toArray(Byte[]::new)))));
        TypeAdapters.register(Byte[].class, TypeAdapters.getNumberArrayAdapter(Byte.class, Number::byteValue, stream -> (Byte[])stream.toArray(Byte[]::new)));
        TypeAdapters.register(char[].class, TypeAdapters.getArrayAdapter(list -> ArrayUtils.toPrimitive((Character[])list.toArray(new Character[0]))));
        TypeAdapters.register(Character[].class, TypeAdapters.getArrayAdapter(list -> list.toArray(new Character[0])));
        TypeAdapters.register(Double.TYPE, Double.class, TypeAdapters.getNumberAdapter(Double::parseDouble));
        TypeAdapters.register(double[].class, TypeAdapters.getNumberArrayAdapter(Double.class, Number::doubleValue, stream -> ArrayUtils.toPrimitive((Double[])((Double[])stream.toArray(Double[]::new)))));
        TypeAdapters.register(Double[].class, TypeAdapters.getNumberArrayAdapter(Double.class, Number::doubleValue, stream -> (Double[])stream.toArray(Double[]::new)));
        TypeAdapters.register(Float.TYPE, Float.class, TypeAdapters.getNumberAdapter(Float::parseFloat));
        TypeAdapters.register(float[].class, TypeAdapters.getNumberArrayAdapter(Float.class, Number::floatValue, stream -> ArrayUtils.toPrimitive((Float[])((Float[])stream.toArray(Float[]::new)))));
        TypeAdapters.register(Float[].class, TypeAdapters.getNumberArrayAdapter(Float.class, Number::floatValue, stream -> (Float[])stream.toArray(Float[]::new)));
        TypeAdapters.register(Long.TYPE, Long.class, TypeAdapters.getNumberAdapter(Long::parseLong));
        TypeAdapters.register(long[].class, TypeAdapters.getNumberArrayAdapter(Long.class, Number::longValue, stream -> ArrayUtils.toPrimitive((Long[])((Long[])stream.toArray(Long[]::new)))));
        TypeAdapters.register(Long[].class, TypeAdapters.getNumberArrayAdapter(Long.class, Number::longValue, stream -> (Long[])stream.toArray(Long[]::new)));
        TypeAdapters.register(Integer.TYPE, Integer.class, TypeAdapters.getNumberAdapter(Integer::parseInt));
        TypeAdapters.register(int[].class, TypeAdapters.getNumberArrayAdapter(Integer.class, Number::intValue, stream -> ArrayUtils.toPrimitive((Integer[])((Integer[])stream.toArray(Integer[]::new)))));
        TypeAdapters.register(Integer[].class, TypeAdapters.getNumberArrayAdapter(Integer.class, Number::intValue, stream -> (Integer[])stream.toArray(Integer[]::new)));
        TypeAdapters.register(Short.TYPE, Short.class, TypeAdapters.getNumberAdapter(Short::parseShort));
        TypeAdapters.register(short[].class, TypeAdapters.getNumberArrayAdapter(Short.class, Number::shortValue, stream -> ArrayUtils.toPrimitive((Short[])((Short[])stream.toArray(Short[]::new)))));
        TypeAdapters.register(Short[].class, TypeAdapters.getNumberArrayAdapter(Short.class, Number::shortValue, stream -> (Short[])stream.toArray(Short[]::new)));
        TypeAdapters.register(String.class, new TypeAdapter(){

            @Override
            public String asString(Object value) {
                return value instanceof Enum ? ((Enum)value).name() : (String)value;
            }
        });
        TypeAdapters.register(String[].class, new TypeAdapter(){

            @Override
            public String asString(Object value) {
                return value instanceof Enum ? ((Enum)value).name() : String.valueOf(value);
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TypeAdapters.register(Path.class, new PathTypeAdapter(false));
        TypeAdapters.register(Path[].class, new PathTypeAdapter(true));
    }
}

