/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.Checkbox;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.menu.MultiLayerMenu;

public final class SettingsEditor
extends AbstractContainer<IWidget> {
    private final List<IWidget> children = new ArrayList<IWidget>();

    public SettingsEditor(final MultiLayerMenu<?> menu) {
        this.setDimensions(menu.getWidth(), menu.getContentHeight());
        AbstractIconButton close = new AbstractIconButton(this.getWidth() - 8 - 1, this.getHeight() - 8 - 1, 8, 8){

            @Override
            public void render(int mouseX, int mouseY, float particleTicks) {
                super.render(mouseX, mouseY, particleTicks);
                if (this.isHovered()) {
                    WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"menu.sfm.CloseEditor.Info", (Object[])new Object[0]), mouseX, mouseY);
                }
            }

            @Override
            public TextureWrapper getTextureNormal() {
                return FactoryManagerGUI.CLOSE_ICON;
            }

            @Override
            public TextureWrapper getTextureHovered() {
                return FactoryManagerGUI.CLOSE_ICON_HOVERED;
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                menu.openEditor(null);
                return super.mouseClicked(mouseX, mouseY, button);
            }

            @Override
            public BoxSizing getBoxSizing() {
                return BoxSizing.PHANTOM;
            }
        };
        close.setParentWidget(this);
        this.children.add(close);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        super.render(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public Checkbox addOption(boolean value, String translationKey) {
        Checkbox checkbox = new Checkbox(0, 0, 8, 8);
        checkbox.setChecked(value);
        checkbox.translateLabel(translationKey);
        this.children.add(checkbox);
        this.reflow();
        return checkbox;
    }

    public NumberField<Integer> addIntegerInput(int defaultValue, int lowerBound, int upperBound) {
        NumberField<Integer> field = NumberField.integerFieldRanged(33, 12, defaultValue, lowerBound, upperBound);
        this.children.add(field);
        this.reflow();
        return field;
    }

    public void addLine(IWidget widget) {
        this.children.add(widget);
    }

    @Override
    public Collection<IWidget> getChildren() {
        return this.children;
    }

    @Override
    public void reflow() {
        FlowLayout.vertical(this.children, 4, 4, 4);
    }

    @Override
    @Nonnull
    public MultiLayerMenu<?> getParentWidget() {
        return (MultiLayerMenu)Objects.requireNonNull(super.getParentWidget());
    }
}

