/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.util.Direction;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.widget.Checkbox;
import vswe.stevesfactory.library.gui.widget.RadioButton;
import vswe.stevesfactory.library.gui.widget.RadioController;
import vswe.stevesfactory.library.gui.widget.TextList;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.utils.Utils;

public class RedstoneSidesMenu<P extends IProcedure & IClientDataStorage>
extends Menu<P> {
    private final Map<Direction, Checkbox> sides;
    private final String menuName;
    private final int id;

    public RedstoneSidesMenu(int id, BooleanSupplier firstOptionGetter, Runnable firstOptionSetter, String firstOptionName, BooleanSupplier secondOptionGetter, Runnable secondOptionSetter, String secondOptionName, String menuName, String infoText) {
        this.id = id;
        this.menuName = menuName;
        RadioController filterTypeController = new RadioController();
        RadioButton firstOption = new RadioButton(filterTypeController);
        RadioButton secondOption = new RadioButton(filterTypeController);
        int y = HEADING_BOX.getPortionHeight() + 4;
        firstOption.setLocation(4, y);
        firstOption.setLabel(firstOptionName);
        firstOption.check(firstOptionGetter.getAsBoolean());
        firstOption.onChecked = firstOptionSetter;
        secondOption.setLocation(this.getWidth() / 2, y);
        secondOption.setLabel(secondOptionName);
        secondOption.check(secondOptionGetter.getAsBoolean());
        secondOption.onChecked = secondOptionSetter;
        this.addChildren(firstOption);
        this.addChildren(secondOption);
        this.sides = new EnumMap<Direction, Checkbox>(Direction.class);
        for (Direction direction : Utils.DIRECTIONS) {
            Checkbox box = new Checkbox();
            box.translateLabel("gui.sfm." + direction.func_176610_l());
            this.addChildren(box);
            this.sides.put(direction, box);
        }
        FlowLayout.reflow(4, 30, this.getWidth(), this.sides);
        TextList info = new TextList(this.getWidth() - 8, 16, new ArrayList<String>());
        info.setFontHeight(6);
        info.addLineSplit(infoText);
        info.setLocation(4, firstOption.getYBottom() + 2);
        this.addChildren(info);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        Object procedure = this.getLinkedProcedure();
        for (Map.Entry<Direction, Checkbox> entry : this.sides.entrySet()) {
            Checkbox box = entry.getValue();
            box.setChecked(((IDirectionTarget)procedure).isEnabled(this.id, entry.getKey()));
            box.onStateChange = b -> ((IDirectionTarget)((Object)procedure)).setEnabled(this.id, (Direction)entry.getKey(), b);
        }
    }

    @Override
    public String getHeadingText() {
        return this.menuName;
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }
}

