/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.layout.properties.HorizontalAlignment;
import vswe.stevesfactory.library.gui.layout.properties.Side;
import vswe.stevesfactory.library.gui.widget.RadioButton;
import vswe.stevesfactory.library.gui.widget.RadioController;
import vswe.stevesfactory.library.gui.widget.box.ScrollArrow;
import vswe.stevesfactory.library.gui.widget.box.WrappingList;
import vswe.stevesfactory.logic.FilterType;
import vswe.stevesfactory.logic.item.ItemTraitsFilter;
import vswe.stevesfactory.logic.procedure.IItemFilterTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.FilterSlot;
import vswe.stevesfactory.ui.manager.menu.MultiLayerMenu;
import vswe.stevesfactory.ui.manager.menu.SettingsEditor;

public class ItemTraitsFilterMenu<P extends IProcedure & IClientDataStorage>
extends MultiLayerMenu<P> {
    private static final Supplier<Integer> FILTER_SLOTS = () -> 20;
    private final int id;
    private final String name;
    private final RadioButton whitelist;
    private final RadioButton blacklist;
    private final WrappingList<FilterSlot> slots;
    private SettingsEditor settings;

    public ItemTraitsFilterMenu(int id) {
        this(id, I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits", (Object[])new Object[0]));
    }

    public ItemTraitsFilterMenu(int id, String name) {
        this.id = id;
        this.name = name;
        RadioController filterTypeController = new RadioController();
        this.whitelist = new RadioButton(filterTypeController);
        this.blacklist = new RadioButton(filterTypeController);
        int y = HEADING_BOX.getPortionHeight() + 4;
        this.whitelist.setLocation(4, y);
        this.whitelist.setLabel(I18n.func_135052_a((String)"gui.sfm.whitelist", (Object[])new Object[0]));
        this.blacklist.setLocation(this.getWidth() / 2, y);
        this.blacklist.setLabel(I18n.func_135052_a((String)"gui.sfm.blacklist", (Object[])new Object[0]));
        this.slots = new WrappingList(false);
        this.slots.setLocation(4, this.whitelist.getYBottom() + 4);
        this.slots.setItemsPerRow(5);
        this.slots.setVisibleRows(2);
        this.slots.setDimensions(this.slots.getContentArea().width, this.getContentHeight() - this.whitelist.getHeight() - 8);
        this.slots.getScrollUpArrow().setLocation(100, 0);
        this.slots.alignArrows();
        MultiLayerMenu.OpenSettingsButton openSettings = new MultiLayerMenu.OpenSettingsButton(0, 0);
        ScrollArrow arrow = this.slots.getScrollDownArrow();
        int ax = this.slots.getX() + arrow.getX();
        int ay = this.slots.getY() + arrow.getY();
        openSettings.alignTo(ax, ay, ax + arrow.getWidth(), ay + arrow.getHeight(), Side.BOTTOM, HorizontalAlignment.CENTER);
        openSettings.moveY(8);
        this.addChildren(this.whitelist);
        this.addChildren(this.blacklist);
        this.addChildren(this.slots);
        this.addChildren(openSettings);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        ItemTraitsFilter filter = this.getLinkedFilter();
        for (int i = 0; i < FILTER_SLOTS.get(); ++i) {
            ItemStack stack;
            if (i < filter.getItems().size()) {
                stack = filter.getItems().get(i);
            } else {
                stack = ItemStack.field_190927_a;
                filter.getItems().add(ItemStack.field_190927_a);
            }
            this.slots.addElement(new FilterSlot(filter, i, stack));
        }
        switch (filter.type) {
            case WHITELIST: {
                this.whitelist.check(true);
                break;
            }
            case BLACKLIST: {
                this.blacklist.check(true);
            }
        }
        this.whitelist.onChecked = () -> {
            filter.type = FilterType.WHITELIST;
        };
        this.blacklist.onChecked = () -> {
            filter.type = FilterType.BLACKLIST;
        };
        this.settings = new SettingsEditor(this);
        this.settings.addOption((boolean)filter.isMatchingAmount(), (String)"menu.sfm.ItemFilter.Traits.MatchAmount").onStateChange = filter::setMatchingAmount;
        this.settings.addOption((boolean)filter.isMatchingDamage(), (String)"menu.sfm.ItemFilter.Traits.MatchDamage").onStateChange = filter::setMatchingDamage;
        this.settings.addOption((boolean)filter.isMatchingTag(), (String)"menu.sfm.ItemFilter.Traits.MatchTag").onStateChange = filter::setMatchingTag;
    }

    @Override
    public SettingsEditor getEditor() {
        return this.settings;
    }

    public ItemTraitsFilter getLinkedFilter() {
        return (ItemTraitsFilter)((IItemFilterTarget)this.getLinkedProcedure()).getFilter(this.id);
    }

    @Override
    public String getHeadingText() {
        return this.name;
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }
}

