/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.box.WrappingList;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.menu.BlockTarget;

public class InventorySelectionMenu<P extends IInventoryTarget & IProcedure>
extends Menu<P> {
    private final int id;
    private final String name;
    private final String errorMessage;
    private WrappingList<BlockTarget> list;

    public InventorySelectionMenu(int id, Capability<?> cap) {
        this(id, I18n.func_135052_a((String)"menu.sfm.InventorySelection", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemIO.NoInv", (Object[])new Object[0]), cap);
    }

    public InventorySelectionMenu(int id, String name, String errorMessage, Capability<?> cap) {
        this.id = id;
        this.name = name;
        this.errorMessage = errorMessage;
        this.list = new WrappingList("");
        this.list.setLocation(4, HEADING_BOX.getPortionHeight() + 4);
        this.list.setItemsPerRow(5);
        this.list.setVisibleRows(2);
        this.list.getContentArea().y += this.list.getSearchBoxHeight() + 2;
        this.list.setDimensions(this.list.getContentArea().width, this.getContentHeight() - 8);
        this.list.getScrollUpArrow().setLocation(100, 24);
        this.list.alignArrows();
        FactoryManagerGUI gui = (FactoryManagerGUI)WidgetScreen.getCurrent();
        INetworkController controller = Objects.requireNonNull((INetworkController)Minecraft.func_71410_x().field_71441_e.func_175625_s(gui.getController().getPosition()));
        for (BlockPos pos : controller.getLinkedInventories(cap)) {
            this.list.addElement(new BlockTarget(pos));
        }
        this.addChildren(this.list);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        HashSet<BlockPos> poses = new HashSet<BlockPos>(((IInventoryTarget)this.getLinkedProcedure()).getInventories(this.id));
        for (BlockTarget target : this.list.getContents()) {
            if (!poses.contains(target.pos)) continue;
            target.setSelected(true);
        }
    }

    @Override
    public void expand() {
        super.expand();
    }

    @Override
    public String getHeadingText() {
        return this.name;
    }

    @Override
    protected void updateData() {
        IInventoryTarget procedure = (IInventoryTarget)this.getLinkedProcedure();
        List<BlockPos> inventories = procedure.getInventories(this.id);
        inventories.clear();
        for (BlockTarget target : this.list.getContents()) {
            if (!target.isSelected()) continue;
            inventories.add(target.pos);
        }
        procedure.markDirty();
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        if (!this.hasAnythingSelected()) {
            errors.add(this.errorMessage);
        }
        return errors;
    }

    private boolean hasAnythingSelected() {
        for (BlockTarget target : this.list.getContents()) {
            if (!target.isSelected()) continue;
            return true;
        }
        return false;
    }
}

