/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.TextList;
import vswe.stevesfactory.logic.procedure.IntervalTriggerProcedure;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;

public class IntervalMenu
extends Menu<IntervalTriggerProcedure> {
    public static final int MARGIN_MIDDLE_UNIT_TEXT = 10;
    private final NumberField<Integer> interval = NumberField.integerFieldRanged(38, 14, 1, 1, 999);

    public IntervalMenu() {
        int x = RenderingHelper.getXForAlignedCenter(0, this.getWidth(), this.interval.getWidth() + 10 + RenderingHelper.fontRenderer().func_78256_a(this.getUnitText()));
        this.interval.setValue(1);
        this.interval.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
        this.interval.setLocation(x, 50);
        int desX = this.interval.getX();
        TextList description = new TextList(this.getWidth() - x * 2, 0, new ArrayList<String>());
        description.setLocation(desX, HEADING_BOX.getPortionHeight() + 8);
        description.setFitContents(true);
        description.addLineSplit(this.getWidth() - 8, I18n.func_135052_a((String)"menu.sfm.Interval.Info", (Object[])new Object[0]));
        description.setFontHeight(8);
        this.addChildren(this.interval);
        this.addChildren(description);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<IntervalTriggerProcedure> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        IntervalTriggerProcedure procedure = (IntervalTriggerProcedure)this.getLinkedProcedure();
        this.interval.setValue(procedure.interval / 20);
        this.interval.onValueUpdated = seconds -> {
            procedure.interval = seconds * 20;
        };
    }

    @Override
    public String getHeadingText() {
        return I18n.func_135052_a((String)"menu.sfm.Interval", (Object[])new Object[0]);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        super.render(mouseX, mouseY, particleTicks);
    }

    @Override
    public void renderContents(int mouseX, int mouseY, float particleTicks) {
        super.renderContents(mouseX, mouseY, particleTicks);
        RenderingHelper.drawTextCenteredVertically(this.getUnitText(), this.interval.getAbsoluteXRight() + 10, this.interval.getAbsoluteY(), this.interval.getAbsoluteYBottom(), -12566464);
    }

    public String getUnitText() {
        return I18n.func_135052_a((String)"gui.sfm.seconds", (Object[])new Object[0]);
    }

    public int getIntervalSeconds() {
        return (Integer)this.interval.getValue();
    }

    public int getIntervalTicks() {
        return this.getIntervalSeconds() * 20;
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        return errors;
    }
}

