/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Direction;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.menu.DirectionSelectionMenu;

class DirectionButton
extends AbstractIconButton {
    public static final TextureWrapper NORMAL = TextureWrapper.ofFlowComponent(0, 70, 31, 12);
    public static final TextureWrapper HOVERED = NORMAL.toDown(1);
    public static final TextureWrapper DISABLED = NORMAL.toDown(2);
    public static final TextureWrapper SELECTED_NORMAL = NORMAL.toRight(1);
    public static final TextureWrapper SELECTED_HOVERED = SELECTED_NORMAL.toDown(1);
    public static final TextureWrapper SELECTED_DISABLED = SELECTED_NORMAL.toDown(2);
    private boolean selected = false;
    private boolean editing = false;
    public BooleanConsumer onStateChanged = b -> {};
    private final String name;

    public DirectionButton(Direction direction) {
        super(0, 0, 31, 12);
        this.name = I18n.func_135052_a((String)("gui.sfm." + direction.func_176610_l()), (Object[])new Object[0]);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        super.render(mouseX, mouseY, particleTicks);
        RenderingHelper.drawTextCenteredVertically(this.name, this.getAbsoluteX() + 2, this.getAbsoluteY(), this.getAbsoluteYBottom(), -11711155);
    }

    @Override
    public TextureWrapper getTextureNormal() {
        return this.selected ? SELECTED_NORMAL : NORMAL;
    }

    @Override
    public TextureWrapper getTextureHovered() {
        return this.selected ? SELECTED_HOVERED : HOVERED;
    }

    @Override
    public TextureWrapper getTextureDisabled() {
        return this.selected ? SELECTED_DISABLED : DISABLED;
    }

    @Override
    protected void preRenderEvent(int mx, int my) {
        RenderEventDispatcher.onPreRender(this, mx, my);
    }

    @Override
    protected void postRenderEvent(int mx, int my) {
        RenderEventDispatcher.onPostRender(this, mx, my);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.setEditing(!this.editing);
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        for (IWidget child : ((Menu)this.getParentWidget()).getChildren()) {
            if (!(child instanceof DirectionButton) || child == this) continue;
            child.setEnabled(!editing);
        }
        if (editing) {
            this.setEnabled(true);
            ((DirectionSelectionMenu)this.getParentWidget()).editDirection(this);
        } else {
            ((DirectionSelectionMenu)this.getParentWidget()).clearEditing();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.onStateChanged.accept(selected);
    }

    public void toggleSelected() {
        this.setSelected(!this.selected);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.editing = false;
            ((DirectionSelectionMenu)this.getParentWidget()).clearEditing();
        }
    }

    @Override
    @Nonnull
    public DirectionSelectionMenu<?> getParentWidget() {
        return Objects.requireNonNull((DirectionSelectionMenu)super.getParentWidget());
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Selected=" + this.selected);
        receiver.line("Editing=" + this.editing);
    }
}

