/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.item;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.item.IItemBuffer;
import vswe.stevesfactory.logic.item.DirectBufferElement;
import vswe.stevesfactory.logic.item.RecipeInfo;

public class CraftingBufferElement
implements IItemBuffer {
    private final IExecutionContext context;
    private RecipeInfo recipe;
    private int outputBase = -1;
    private ItemStack result = ItemStack.field_190927_a;

    public CraftingBufferElement(IExecutionContext context) {
        this.context = context;
    }

    public ICraftingRecipe getRecipe() {
        return this.recipe.getRecipe();
    }

    public void setRecipe(RecipeInfo recipe) {
        this.recipe = recipe;
        this.result = recipe.getRecipe().func_77572_b(null);
        this.outputBase = this.result.func_190916_E();
    }

    @Override
    public ItemStack getStack() {
        this.refresh();
        return this.result;
    }

    @Override
    public void setStack(ItemStack stack) {
        Preconditions.checkArgument((this.result.func_77969_a(stack) || stack.func_190926_b() ? 1 : 0) != 0);
        this.result = stack;
    }

    @Override
    public int getUsed() {
        return 0;
    }

    @Override
    public void setUsed(int used) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        Map<Item, DirectBufferElement> buffers = this.context.getItemBuffers(DirectBufferElement.class);
        int batchesAvailable = Integer.MAX_VALUE;
        for (Object2IntMap.Entry ingredient : this.recipe.getIngredients()) {
            int consumption = ingredient.getIntValue();
            int available = 0;
            for (ItemStack matchable : ((Ingredient)ingredient.getKey()).func_193365_a()) {
                DirectBufferElement buffer = buffers.get(matchable.func_77973_b());
                if (buffer == null) continue;
                available += buffer.getStack().func_190916_E();
            }
            int totalAvailableSets = available / consumption;
            if (totalAvailableSets == 0) {
                batchesAvailable = 0;
                break;
            }
            batchesAvailable = Math.min(batchesAvailable, totalAvailableSets);
        }
        this.result.func_190920_e(this.outputBase * batchesAvailable);
    }

    @Override
    public void use(int amount) {
        int actualSize = amount / this.outputBase;
        Map<Item, DirectBufferElement> buffers = this.context.getItemBuffers(DirectBufferElement.class);
        for (Object2IntMap.Entry ingredient : this.recipe.getIngredients()) {
            int desire = actualSize * ingredient.getIntValue();
            for (ItemStack matchable : ((Ingredient)ingredient.getKey()).func_193365_a()) {
                DirectBufferElement buffer = buffers.get(matchable.func_77973_b());
                if (buffer == null) continue;
                int consumption = Math.min(buffer.stack.func_190916_E(), desire);
                buffer.use(consumption);
                buffer.stack.func_190918_g(consumption);
                desire -= consumption;
            }
        }
    }

    @Override
    public void put(int amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() {
    }
}

