/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.execution;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.fluid.IFluidBuffer;
import vswe.stevesfactory.api.logic.item.IItemBuffer;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.logic.item.CraftingBufferElement;
import vswe.stevesfactory.logic.item.DirectBufferElement;

public class ProcedureExecutor
implements IExecutionContext {
    private static final Object2IntMap<Class<? extends IItemBuffer>> itemOrderAssociation = new Object2IntOpenHashMap();
    private static int nextItemOrder = 0;
    private static final Object2IntMap<Class<? extends IFluidBuffer>> fluidOrderAssociation = new Object2IntOpenHashMap();
    private static int nextFluidOrder = 0;
    private final INetworkController controller;
    private final World world;
    private Deque<IProcedure> executionStack = new ArrayDeque<IProcedure>();
    private Object2IntOpenHashMap<IProcedure> executionFrequency = new Object2IntOpenHashMap();
    private Map<Item, IItemBuffer>[] itemBufferElements = new IdentityHashMap[itemOrderAssociation.size()];
    private Map<Fluid, IFluidBuffer>[] fluidBufferElements = new IdentityHashMap[fluidOrderAssociation.size()];
    private ClassToInstanceMap<Object> customData = MutableClassToInstanceMap.create();

    public static void registerItemBufferType(Class<? extends IItemBuffer> type) {
        itemOrderAssociation.put(type, nextItemOrder++);
    }

    public static void registerFluidBufferType(Class<? extends IFluidBuffer> type) {
        fluidOrderAssociation.put(type, nextFluidOrder++);
    }

    public ProcedureExecutor(INetworkController controller, World world) {
        this.controller = controller;
        this.world = world;
    }

    @Override
    public INetworkController getController() {
        return this.controller;
    }

    @Override
    public World getControllerWorld() {
        return this.world;
    }

    @Override
    public void push(@Nullable IProcedure frame) {
        int freq;
        if (frame != null && (freq = this.executionFrequency.addTo((Object)frame, 1)) < (Integer)Config.COMMON.repeatThreshold.get()) {
            this.executionStack.push(frame);
        }
    }

    public void start(IProcedure hat) {
        this.executionStack.push(hat);
        while (!this.executionStack.isEmpty()) {
            this.executionStack.poll().execute(this);
        }
        this.cleanup();
    }

    private Map<Item, IItemBuffer> getOrCreateItemBuffers(int index) {
        if (this.itemBufferElements[index] != null) {
            return this.itemBufferElements[index];
        }
        IdentityHashMap<Item, IItemBuffer> map = new IdentityHashMap<Item, IItemBuffer>();
        this.itemBufferElements[index] = map;
        return map;
    }

    @Override
    public <T extends IItemBuffer> Map<Item, T> getItemBuffers(Class<T> type) {
        int index = itemOrderAssociation.getInt(type);
        Map<Item, IItemBuffer> map = this.getOrCreateItemBuffers(index);
        return map;
    }

    private Map<Fluid, IFluidBuffer> getOrCreateFluidBuffers(int index) {
        if (this.fluidBufferElements[index] != null) {
            return this.fluidBufferElements[index];
        }
        IdentityHashMap<Fluid, IFluidBuffer> map = new IdentityHashMap<Fluid, IFluidBuffer>();
        this.fluidBufferElements[index] = map;
        return map;
    }

    @Override
    public <T extends IFluidBuffer> Map<Fluid, T> getFluidBuffers(Class<T> type) {
        int index = itemOrderAssociation.getInt(type);
        Map<Fluid, IFluidBuffer> map = this.getOrCreateFluidBuffers(index);
        return map;
    }

    @Override
    public ClassToInstanceMap<Object> getCustomData() {
        return this.customData;
    }

    @Override
    public void forEachItemBuffer(BiConsumer<Item, IItemBuffer> lambda) {
        for (Map<Item, IItemBuffer> buffers : this.itemBufferElements) {
            if (buffers == null) continue;
            buffers.forEach(lambda);
        }
    }

    @Override
    public void forEachFluidBuffer(BiConsumer<Fluid, IFluidBuffer> lambda) {
        for (Map<Fluid, IFluidBuffer> buffers : this.fluidBufferElements) {
            if (buffers == null) continue;
            buffers.forEach(lambda);
        }
    }

    private void cleanup() {
        Object element;
        for (Map<Item, IItemBuffer> map : this.itemBufferElements) {
            if (map == null) continue;
            for (Map.Entry<Item, IItemBuffer> entry : map.entrySet()) {
                element = entry.getValue();
                element.cleanup();
            }
        }
        for (Map<Object, Object> map : this.fluidBufferElements) {
            if (map == null) continue;
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                element = (IFluidBuffer)entry.getValue();
                element.cleanup();
            }
        }
    }

    static {
        ProcedureExecutor.registerItemBufferType(CraftingBufferElement.class);
        ProcedureExecutor.registerItemBufferType(DirectBufferElement.class);
    }
}

