/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.window;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nullable;
import vswe.stevesfactory.library.gui.widget.IWidget;

public interface IWindow {
    public Dimension getBorder();

    default public int getWidth() {
        return this.getBorder().width;
    }

    default public int getHeight() {
        return this.getBorder().height;
    }

    public int getBorderSize();

    public Dimension getContentDimensions();

    default public int getContentWidth() {
        return this.getContentDimensions().width;
    }

    default public int getContentHeight() {
        return this.getContentDimensions().height;
    }

    public List<? extends IWidget> getChildren();

    public Point getPosition();

    default public void setPosition(int x, int y) {
        this.getPosition().x = x;
        this.getPosition().y = y;
    }

    default public int getX() {
        return this.getPosition().x;
    }

    default public int getY() {
        return this.getPosition().y;
    }

    default public int getContentX() {
        return this.getX() + this.getBorderSize();
    }

    default public int getContentY() {
        return this.getY() + this.getBorderSize();
    }

    public void render(int var1, int var2, float var3);

    @Nullable
    public IWidget getFocusedWidget();

    public void setFocusedWidget(@Nullable IWidget var1);

    default public boolean changeFocus(IWidget widget, boolean focus) {
        if (focus && widget.isEnabled()) {
            this.setFocusedWidget(widget);
            return true;
        }
        this.setFocusedWidget(null);
        return false;
    }

    public void onRemoved();

    default public boolean isInside(double x, double y) {
        int selfX = this.getX();
        int selfY = this.getY();
        int selfXBR = selfX + this.getWidth();
        int selfYBR = selfY + this.getHeight();
        return x >= (double)selfX && x < (double)selfXBR && y >= (double)selfY && y < (double)selfYBR;
    }

    public boolean mouseClicked(double var1, double var3, int var5);

    public boolean mouseReleased(double var1, double var3, int var5);

    public boolean mouseDragged(double var1, double var3, int var5, double var6, double var8);

    public boolean mouseScrolled(double var1, double var3, double var5);

    public boolean keyPressed(int var1, int var2, int var3);

    public boolean keyReleased(int var1, int var2, int var3);

    public boolean charTyped(char var1, int var2);

    public void mouseMoved(double var1, double var3);

    public void update(float var1);
}

