/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.window;

import java.awt.Dimension;
import java.awt.Point;
import javax.annotation.Nullable;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.Inspections;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.IContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.window.IWindow;

public abstract class AbstractWindow
implements IWindow,
Inspections.IInspectionInfoProvider {
    public final Point position = new Point();
    public final Dimension contents = new Dimension();
    public final Dimension border = new Dimension();
    private IWidget focusedWidget;

    @Override
    public Dimension getBorder() {
        return this.border;
    }

    @Override
    public Dimension getContentDimensions() {
        return this.contents;
    }

    public void setContents(int width, int height) {
        this.contents.width = width;
        this.contents.height = height;
        int borderSize = this.getBorderSize();
        this.border.width = borderSize + width + borderSize;
        this.border.height = borderSize + height + borderSize;
    }

    public void setBorder(int width, int height) {
        this.border.width = width;
        this.border.height = height;
        int borderSize = this.getBorderSize();
        this.contents.width = width - borderSize * 2;
        this.contents.height = height - borderSize * 2;
    }

    public void centralize() {
        this.position.x = WidgetScreen.screenWidth() / 2 - this.getWidth() / 2;
        this.position.y = WidgetScreen.screenHeight() / 2 - this.getHeight() / 2;
        this.updateChildPosition();
    }

    @Override
    public void setPosition(int x, int y) {
        IWindow.super.setPosition(x, y);
        this.updateChildPosition();
    }

    protected final void updateChildPosition() {
        if (this.getChildren() != null) {
            for (IWidget iWidget : this.getChildren()) {
                iWidget.onParentPositionChanged();
            }
        }
    }

    protected final void renderChildren(int mouseX, int mouseY, float particleTicks) {
        for (IWidget iWidget : this.getChildren()) {
            iWidget.render(mouseX, mouseY, particleTicks);
        }
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public IWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    @Override
    public void setFocusedWidget(@Nullable IWidget widget) {
        this.focusedWidget = widget;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isInside(mouseX, mouseY) || !iWidget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isInside(mouseX, mouseY) || !iWidget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isFocused() || !iWidget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isInside(mouseX, mouseY) || !iWidget.mouseScrolled(mouseX, mouseY, scroll)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isFocused() || !iWidget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isFocused() || !iWidget.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char charTyped, int keyCode) {
        for (IWidget iWidget : this.getChildren()) {
            if (!(iWidget instanceof IContainer) && !iWidget.isFocused() || !iWidget.charTyped(charTyped, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        for (IWidget iWidget : this.getChildren()) {
            iWidget.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public void update(float particleTicks) {
        for (IWidget iWidget : this.getChildren()) {
            iWidget.update(particleTicks);
        }
    }

    @Override
    public void onRemoved() {
        for (IWidget iWidget : this.getChildren()) {
            iWidget.onRemoved();
        }
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        receiver.line(this.toString());
        receiver.line("Position=" + this.getPosition());
        receiver.line("Dimensions=" + this.getBorder());
        receiver.line("BorderSize=" + this.getBorderSize());
        receiver.line("ContentDimensions=" + this.getContentDimensions());
        receiver.line("ContentX=" + this.getContentX());
        receiver.line("ContentY=" + this.getContentY());
    }
}

