/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget.slot;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.slot.AbstractItemSlot;

public class ItemSlotPanel
extends AbstractContainer<AbstractItemSlot> {
    private int width;
    private int height;
    private List<AbstractItemSlot> children;

    public ItemSlotPanel(int width, int height) {
        this(width, height, DefaultSlot::new);
    }

    public ItemSlotPanel(int width, int height, Supplier<AbstractItemSlot> factory) {
        this.width = width;
        this.height = height;
        this.children = new ArrayList<AbstractItemSlot>();
        int size = width * height;
        for (int i = 0; i < size; ++i) {
            this.addChildren(factory.get());
        }
        this.updateDimensions();
        this.reflow();
    }

    public ItemSlotPanel(int width, int height, List<ItemStack> stacks) {
        this(width, height, stacks, DefaultSlot::new);
    }

    public ItemSlotPanel(int width, int height, List<ItemStack> stacks, Function<ItemStack, AbstractItemSlot> factory) {
        int size = width * height;
        Preconditions.checkArgument((size == stacks.size() ? 1 : 0) != 0);
        this.width = width;
        this.height = height;
        this.children = new ArrayList<AbstractItemSlot>();
        for (int i = 0; i < size; ++i) {
            this.addChildren(factory.apply(stacks.get(i)));
        }
        this.updateDimensions();
        this.reflow();
    }

    private void updateDimensions() {
        int pw = this.children.stream().limit(this.width).mapToInt(IWidget::getWidth).sum();
        int ph = this.children.stream().limit(this.height).mapToInt(IWidget::getWidth).sum();
        this.setDimensions(pw, ph);
    }

    @Override
    public List<AbstractItemSlot> getChildren() {
        return this.children;
    }

    public ItemSlotPanel addChildren(AbstractItemSlot widget) {
        this.children.add(widget);
        return this;
    }

    public ItemSlotPanel addChildren(Collection<AbstractItemSlot> widgets) {
        this.children.addAll(widgets);
        return this;
    }

    @Override
    public void reflow() {
        int x = 0;
        int y = 0;
        int i = 0;
        for (int yi = 0; yi < this.height; ++yi) {
            x = 0;
            int maxHeight = 0;
            for (int xi = 0; xi < this.width; ++xi) {
                AbstractItemSlot slot = this.children.get(i);
                slot.setLocation(x, y);
                x += slot.getWidth();
                maxHeight = Math.max(maxHeight, slot.getHeight());
                ++i;
            }
            y += maxHeight;
        }
    }

    public static class DefaultSlot
    extends AbstractItemSlot {
        private ItemStack stack;

        public DefaultSlot() {
            this(ItemStack.field_190927_a);
        }

        public DefaultSlot(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public ItemStack getRenderedStack() {
            return this.stack;
        }

        @Override
        @Nonnull
        public ItemSlotPanel getParentWidget() {
            return (ItemSlotPanel)Objects.requireNonNull(super.getParentWidget());
        }
    }
}

