/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.awt.Dimension;
import java.awt.Point;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.INamedElement;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class Icon
extends AbstractWidget
implements INamedElement,
LeafWidgetMixin {
    private TextureWrapper texture;

    public Icon(int x, int y, TextureWrapper texture) {
        super(x, y, texture.getPortionWidth(), texture.getPortionHeight());
        this.texture = texture;
    }

    public Icon(IWidget parent, Point location, TextureWrapper texture) {
        super(location, new Dimension(texture.getPortionWidth(), texture.getPortionHeight()));
        this.setParentWidget(parent);
        this.texture = texture;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        if (this.isEnabled()) {
            this.texture.draw(this.getAbsoluteX(), this.getAbsoluteY());
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public TextureWrapper getTexture() {
        return this.texture;
    }

    public void setTexture(TextureWrapper texture) {
        this.texture = texture;
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Texture=" + this.texture);
    }

    @Override
    public String getName() {
        return this.texture.toString();
    }
}

