/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class Checkbox
extends AbstractWidget
implements LeafWidgetMixin {
    public static final int NORMAL_BORDER = -11711155;
    public static final int UNCHECKED = -3947581;
    public static final int CHECKED = -10707411;
    public static final int HOVERED_BORDER = -7500403;
    public static final int HOVERED_UNCHECKED = -2631978;
    public static final int HOVERED_CHECKED = -6897799;
    private boolean checked = false;
    private String label = "";
    public BooleanConsumer onStateChange = b -> {};

    public Checkbox() {
        this(0, 0, 9, 9);
    }

    public Checkbox(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        int borderColor;
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        int x1 = this.getAbsoluteX();
        int y1 = this.getAbsoluteY();
        int x2 = this.getAbsoluteXRight();
        int y2 = this.getAbsoluteYBottom();
        boolean hovered = this.isInside(mouseX, mouseY);
        int n = borderColor = hovered ? -7500403 : -11711155;
        int contentColor = hovered ? (this.checked ? -6897799 : -2631978) : (this.checked ? -10707411 : -3947581);
        RenderSystem.disableTexture();
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderingHelper.rectVertices(x1, y1, x2, y2, borderColor);
        RenderingHelper.rectVertices(x1 + 1, y1 + 1, x2 - 1, y2 - 1, contentColor);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        if (!this.label.isEmpty()) {
            RenderingHelper.drawTextCenteredVertically(this.label, x2 + 2, y1, y2, -12566464);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.getWindow().setFocusedWidget(this);
        this.toggle();
        return true;
    }

    public void toggle() {
        this.checked = !this.checked;
        this.onStateChange.accept(this.checked);
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.onStateChange.accept(checked);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void translateLabel(String translationKey) {
        this.label = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
    }

    public void translateLabel(String translationKey, Object ... args) {
        this.label = I18n.func_135052_a((String)translationKey, (Object[])args);
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Checked=" + this.checked);
    }
}

