/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.mixin.ContainerWidgetMixin;
import vswe.stevesfactory.library.gui.window.IWindow;

public abstract class AbstractContainer<T extends IWidget>
extends AbstractWidget
implements IContainer<T>,
ContainerWidgetMixin<T> {
    public AbstractContainer(IWindow window) {
        super(window);
    }

    public AbstractContainer() {
    }

    public AbstractContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public AbstractContainer(Point location, Dimension dimensions) {
        super(location, dimensions);
    }

    @Override
    public void setParentWidget(IWidget newParent) {
        super.setParentWidget(newParent);
        ContainerWidgetMixin.super.setParentWidget(newParent);
    }

    @Override
    public void setWindow(IWindow window) {
        super.setWindow(window);
        Collection children = this.getChildren();
        if (children != null) {
            for (IWidget child : children) {
                child.setParentWidget(this);
            }
        }
    }

    @Override
    public IContainer<T> addChildren(T widget) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContainer<T> addChildren(Collection<T> widgets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onParentPositionChanged() {
        super.onParentPositionChanged();
        this.notifyChildrenForPositionChange();
    }

    @Override
    public void onRelativePositionChanged() {
        super.onRelativePositionChanged();
        this.notifyChildrenForPositionChange();
    }

    public void notifyChildrenForPositionChange() {
        if (this.getChildren() != null) {
            for (IWidget child : this.getChildren()) {
                child.onParentPositionChanged();
            }
        }
    }

    public void adjustMinContent() {
        if (this.getChildren().isEmpty()) {
            return;
        }
        int rightmost = 0;
        int bottommost = 0;
        for (IWidget child : this.getChildren()) {
            int right = child.getX() + child.getWidth();
            int bottom = child.getY() + child.getHeight();
            if (right > rightmost) {
                rightmost = right;
            }
            if (bottom <= bottommost) continue;
            bottommost = bottom;
        }
        this.setDimensions(rightmost, bottommost);
    }

    public void fillWindow() {
        this.setLocation(0, 0);
        this.setDimensions(this.getWindow().getContentDimensions());
    }

    public void attachChildren() {
        for (IWidget child : this.getChildren()) {
            child.setParentWidget(this);
        }
    }
}

